// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_CONSUMER_ADMIN_IMPL_H
#define COS_CONSUMER_ADMIN_IMPL_H

//
// Forward declarations.
//
class ProxySupplier_impl;
typedef OBFixSeq<ProxySupplier_impl*> ProxySupplierPtrSeq;
class EC_EventChannel_impl;
class Event_impl;

//
// The event channel ConsumerAdmin class.
// 
class EC_ConsumerAdmin_impl : public CosEventChannelAdmin_ConsumerAdmin_skel,
                              public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    EC_ConsumerAdmin_impl(const EC_ConsumerAdmin_impl&);
    void operator=(const EC_ConsumerAdmin_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    EC_EventChannel_impl* channel_; // My event channel.

    ProxySupplierPtrSeq proxies_; // Set of proxy suppliers.

    CORBA_ULong nextId_; // ID of the next assigned proxy.

    bool destroyed_; // Has this admin been destroyed?

public:

    EC_ConsumerAdmin_impl(CORBA_ORB_ptr, EC_EventChannel_impl*);
    ~EC_ConsumerAdmin_impl();

    //
    // Standard IDL to C++ Mapping.
    //

    //
    // Get ProxyPushSupplier.
    //
    virtual CosEventChannelAdmin_ProxyPushSupplier_ptr obtain_push_supplier();

    //
    // Get ProxyPullSupplier.
    //
    virtual CosEventChannelAdmin_ProxyPullSupplier_ptr obtain_pull_supplier();

    //
    // Internal methods.
    //
    
    //
    // Receive event from EventChannel.
    //
    void receive(Event_impl*);

    //
    // Remove this proxy from my list
    //
    void removeProxy(ProxySupplier_impl*);

    //
    // Called from the event channel upon destruction.
    //
    void disconnect();
};

#endif
