// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_PROXY_PULL_SUPPLIER_IMPL_H
#define COS_PROXY_PULL_SUPPLIER_IMPL_H

//
// Forward declarations.
//
class EC_EventChannel_impl;
class EC_ConsumerAdmin_impl;
class Event_impl;
typedef OBFixSeq< Event_impl* > EventPtrSeq;

//
// The event channel ProxyPullSupplier implementation
//
class EC_ProxyPullSupplier_impl :
    public CosEventChannelAdmin_ProxyPullSupplier_skel,
    public ProxySupplier_impl,
    public JTCMonitor
{
    CORBA_ORB_var orb_; // The ORB.
    
    CosEventComm_PullConsumer_var consumer_; // My pull consumer.
    
    EC_ConsumerAdmin_impl* admin_; // My admin.
    
    ProxyState state_; // My state.
    
    CORBA_ULong maxEvents_; // Maximum number of pending events.
    
    EventPtrSeq events_; // Queue of pending events.

    CORBA_ULong id_; // My ID.

    //
    // Get the first event.
    //
    Event_impl* getFirstEvent();

public:

    EC_ProxyPullSupplier_impl(CORBA_ORB_ptr orb,
                              EC_ConsumerAdmin_impl*,
                              CORBA_ULong);
    ~EC_ProxyPullSupplier_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    virtual void connect_pull_consumer(CosEventComm_PullConsumer_ptr);

    virtual CORBA_Any* pull();

    virtual CORBA_Any* try_pull(CORBA_Boolean&);

    virtual void disconnect_pull_supplier();

    //
    // Internal methods
    //

    //
    // Receive a new event from the event channel.
    //
    virtual void receive(Event_impl*);

    //
    // Called when the event channel is destroyed.
    //
    virtual void disconnect();

    //
    // Called to release this object reference.
    //
    virtual void release();

    CORBA_ULong proxyId() const { return id_; }
};

#endif
