// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_PROXY_PUSH_SUPPLIER_IMPL_H
#define COS_PROXY_PUSH_SUPPLIER_IMPL_H

//
// Forward declarations.
//
class EC_ConsumerAdmin_impl;
class PusherBaseThread;
typedef JTCHandleT<PusherBaseThread> PusherBaseThreadHandle;

//
// The Event Channel ProxyPushSupplier implementation.
//
class EC_ProxyPushSupplier_impl :
    public CosEventChannelAdmin_ProxyPushSupplier_skel,
    public ProxySupplier_impl,
    public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    EC_ProxyPushSupplier_impl(const EC_ProxyPushSupplier_impl&);
    void operator=(const EC_ProxyPushSupplier_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    EC_ConsumerAdmin_impl* admin_; // My admin.

    ProxyState state_; // My state.

    PusherBaseThreadHandle pusher_; // The event pusher.

    CosEventComm_PushConsumer_var consumer_; // My consumer.

    CORBA_ULong id_; // My ID.

public:
    
    EC_ProxyPushSupplier_impl(CORBA_ORB_ptr, EC_ConsumerAdmin_impl*,
                              CORBA_ULong);
    virtual ~EC_ProxyPushSupplier_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    virtual void connect_push_consumer(CosEventComm_PushConsumer_ptr);

    virtual void disconnect_push_supplier();

    //
    // Internal methods.
    //

    //
    // Receive an event from the channel.
    //
    virtual void receive(Event_impl*);

    //
    // Called when the event channel is destroyed.
    //
    virtual void disconnect();

    //
    // Called to release this object reference.
    //
    virtual void release();

    CORBA_ULong proxyId() const { return id_; }
};

#endif
