// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_SUPPLIER_ADMIN_IMPL_H
#define COS_SUPPLIER_ADMIN_IMPL_H

//
// Forward declarations.
//
class ProxyConsumer_impl;
typedef OBFixSeq<ProxyConsumer_impl*> ProxyConsumerPtrSeq;

//
// Event channel SupplierAdmin.
//
class EC_SupplierAdmin_impl : public CosEventChannelAdmin_SupplierAdmin_skel,
                              public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    EC_SupplierAdmin_impl(const EC_SupplierAdmin_impl&);
    void operator=(const EC_SupplierAdmin_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    EC_EventChannel_impl* channel_; // My event channel.

    ProxyConsumerPtrSeq proxies_; // Set of ProxyConsumers.

    CORBA_ULong nextId_; // ID of the next assigned proxy.

    bool destroyed_; // Has this admin been destroyed?

public:

    EC_SupplierAdmin_impl(CORBA_ORB_ptr, EC_EventChannel_impl*);
    ~EC_SupplierAdmin_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    
    //
    // Get ProxyPushConsumer.
    //
    virtual CosEventChannelAdmin_ProxyPushConsumer_ptr obtain_push_consumer();

    //
    // Get ProxyPullConsumer.
    //
    virtual CosEventChannelAdmin_ProxyPullConsumer_ptr obtain_pull_consumer();

    //
    // Internal methods.
    //

    //
    // Remove this proxy from my list.
    //
    void removeProxy(ProxyConsumer_impl*);

    //
    // Called from the event channel upon destruction.
    //
    void disconnect();
};

#endif
