// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/OCI_IIOP.h>

#include <EventUtil.h>

// ----------------------------------------------------------------------
// EventUtil public member implementation
// ----------------------------------------------------------------------

char*
EventUtil::getConnectionAddrDescription(CORBA_ORB_ptr orb)
{
    CORBA_Object_var obj;
    try
    {
        obj = orb -> resolve_initial_references("OCICurrent");
    }
    catch(const CORBA_ORB::InvalidName&)
    {
    }
    assert(!CORBA_is_nil(obj));
    OCI_Current_var current = OCI_Current::_narrow(obj);
    assert(!CORBA_is_nil(current));
    OCI_TransportInfo_var baseInfo = current -> get_oci_transport_info();
    OCI_IIOP_TransportInfo_var info =
        OCI_IIOP_TransportInfo::_narrow(baseInfo);
    CORBA_String_var desc;
    if(!CORBA_is_nil(info))
    {
        OCI_IIOP_InetAddr_var remoteAddr = info -> remote_addr();
        CORBA_UShort remotePort = info -> remote_port();
        desc = CORBA_string_alloc(60);
        desc[0] = '\0';
        desc += (int)remoteAddr[0];
        desc += '.';
        desc += (int)remoteAddr[1];
        desc += '.';
        desc += (int)remoteAddr[2];
        desc += '.';
        desc += (int)remoteAddr[3];
        desc += ':';
        desc += remotePort;
    }
    else
    {
        desc = CORBA_string_dup("UNKNOWN");
    }
    return desc._retn();
}

