// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// *********************************************************************

#ifndef PROPAGATOR_BASE_THREAD_H
#define PROPAGATOR_BASE_THREAD_H

//
// This class provides a base class for those threads that push and
// pull events.
//
class PropagatorBaseThread : public JTCThread, public JTCMonitor
{
    CORBA_ULong maxRetries_; // Max retries.
    
    CORBA_ULong retryTimeout_; // Initial timeout (msec).
    
    CORBA_Double retryMultiplier_; // Retry multiplier (msec).

    CORBA_ULong retry_; // Number of msec for next retry.
    
    CORBA_ULong retries_; // Number of retries.

protected:

    bool done_; // Are we done?

    CORBA_ULong id_; // The proxy id.

    //
    // Run the retry algorithm.
    //
    bool retry();

    //
    // Delay for msecs.
    //
    void delay(CORBA_ULong);

    //
    // Reset the retry algorithm.
    //
    void resetRetry();

public:

    PropagatorBaseThread(CORBA_ULong, CORBA_ULong, CORBA_ULong, CORBA_Double);
    virtual ~PropagatorBaseThread();

    //
    // Stop the thread.
    //
    void halt();
};

#endif
