// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// *********************************************************************

#ifndef PUSHER_BASE_THREAD_H
#define PUSHER_BASE_THREAD_H

//
// Forward declaration
//
class Event_impl;
typedef OBFixSeq<Event_impl*> EventPtrSeq;

//
// This base class provides an implementation for a thread that pushes
// event data to a client.
//
class PusherBaseThread : public PropagatorBaseThread
{
    EventPtrSeq events_; // The event queue.

    CORBA_ULong maxEvents_; // The maximum number of events to queue.
    
    //
    // Wait until we are terminated or for the next event to
    // arrive. Return the event if available, 0 if not.
    //
    Event_impl* waitEvent();

    //
    // Remove this event from the event queue.
    //
    void removeEvent(Event_impl*);

protected:

    //
    // This enumeration represents the possible return values from a
    // push operation.
    //
    enum PushResult
    {
        Success, // Push succeeded.
        Retry, // Run retry algorithm.
        Failed // Push failed.
    };

private:

    //
    // This method must be implemented by all classes deriving from
    // this class.
    //
    virtual PushResult pushEvent(Event_impl* event) = 0;

protected:
    
    CosEventComm_PushConsumer_var consumer_; // My push consumer.

    CosEventChannelAdmin_ProxyPushSupplier_var proxy_; // My proxy.

public:

    PusherBaseThread(CosEventComm_PushConsumer_ptr,
                     CosEventChannelAdmin_ProxyPushSupplier_ptr,
                     CORBA_ULong,
                     CORBA_ULong, CORBA_ULong, CORBA_ULong, CORBA_Double);
    ~PusherBaseThread();

    //
    // Pass a new event to the Pusher.
    //
    void newEvent(Event_impl*);

    //
    // Run the pusher until stopped, or a push fails.
    //
    virtual void run();
};

//
// Declaration for a handle to a PusherBaseThread
//
typedef JTCHandleT<PusherBaseThread> PusherBaseThreadHandle;

#endif
