// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Properties.h>
#include <OB/Util.h>

#include <SetDefaultProperties.h>
#include <QoS.h>

#include <stdlib.h>

//
// The default properties.
//
const SetDefaultProperties::DefaultProperties
SetDefaultProperties::defaults_[] =
{
    { EventQoS::MAX_RETRIES, "10" },
    { EventQoS::MAX_EVENTS, "10" },
    { EventQoS::RETRY_TIMEOUT, "1000" },
    { EventQoS::RETRY_MULTIPLIER, "2" },
    { EventQoS::PULL_INTERVAL, "0" }
};

//
// Number of default properties.
//
CORBA_ULong SetDefaultProperties::numDefaults_ =
    sizeof(SetDefaultProperties::defaults_)/
    sizeof(SetDefaultProperties::defaults_[0]);

// ----------------------------------------------------------------------
// SetDefaultProperties private member implementation
// ----------------------------------------------------------------------

void
SetDefaultProperties::setDefault(const char* key)
{
    for(CORBA_ULong i = 0; i < numDefaults_; ++i)
	if(strcmp(defaults_[i].key, key) == 0)
	{
	    OBProperties::instance() -> setProperty(defaults_[i].key,
						    defaults_[i].value);
	    return;
	}
}

// ----------------------------------------------------------------------
// SetDefaultProperties public member implementation
// ----------------------------------------------------------------------

//
// Set default values for the properties.
//
void
SetDefaultProperties::setDefaults()
{
    const char* progName = "EventService";

    OBProperties* properties = OBProperties::instance();

    OBMessageViewer* viewer = OBMessageViewer::instance();
    
    //
    // If the value is not set then set to the default.
    //
    CORBA_ULong i;
    for(i = 0; i < numDefaults_; ++i)
	if(properties -> getProperty(defaults_[i].key) == 0)
	    properties -> setProperty(defaults_[i].key, defaults_[i].value);
    
    //
    // Check properties value.
    //
    OBProperties::KeySeq keys = properties -> getKeys("ooc.event.");
    for(i = 0; i < keys.length(); ++i)
    {
	const char* key = keys[i];
	const char* value = properties -> getProperty(key);
	assert(value != 0);
	
	if(strcmp(key, EventQoS::MAX_RETRIES) == 0 ||
	   strcmp(key, EventQoS::PULL_INTERVAL) == 0)
	{
	    if(atoi(value) < 0)
	    {
		CORBA_String_var msg = CORBA_string_dup(progName);
		msg += ": ";
		msg += key;
		msg += " must be >= 0. Using default value";
		viewer -> warning(msg);
		setDefault(key);
	    }
	}
	else if(strcmp(key, EventQoS::MAX_EVENTS) == 0)
	{
	    if(atoi(value) <= 0)
	    {
		CORBA_String_var msg = CORBA_string_dup(progName);
		msg += ": ";
		msg += key;
		msg += " must be > 0. Using default value";
		viewer -> warning(msg);
		setDefault(key);
	    }
	}
	else if(strcmp(key, EventQoS::RETRY_TIMEOUT) == 0 ||
		strcmp(key, EventQoS::RETRY_MULTIPLIER) == 0)
	{
	    int v = atoi(value);
	    if(v < 0 || v > 999999)
	    {
		CORBA_String_var msg = CORBA_string_dup(progName);
		msg += ": ";
		msg += key;
		msg += " must be > 0 and < 999999. Using default value";
		viewer -> warning(msg);
		setDefault(key);
	    }
	}
	else
	{
	    CORBA_String_var msg = CORBA_string_dup(progName);
	    msg += ": `";
	    msg += key;
	    msg += "': unknown property";
	    viewer -> warning(msg);
	}
    }
}
    
