// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_TYPED_PROXY_PUSH_SUPPLIER_IMPL_H
#define COS_TYPED_PROXY_PUSH_SUPPLIER_IMPL_H

//
// Forward declarations
//
class TEC_TypedConsumerAdmin_impl;
class PusherBaseThread;
typedef JTCHandleT<PusherBaseThread> PusherBaseThreadHandle;

//
// The Event Channel ProxyPushSupplier implementation
//
class TEC_ProxyPushSupplier_impl :
    public CosEventChannelAdmin_ProxyPushSupplier_skel,
    public ProxySupplier_impl,
    public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    TEC_ProxyPushSupplier_impl(const TEC_ProxyPushSupplier_impl&);
    void operator=(const TEC_ProxyPushSupplier_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    TEC_TypedConsumerAdmin_impl* admin_; // My admin.

    ProxyState state_; // My state.

    PusherBaseThreadHandle pusher_; // The event pusher.

    CosEventComm_PushConsumer_var consumer_; // My consumer.

    CORBA_ULong id_; // My ID.

public:
    
    TEC_ProxyPushSupplier_impl(CORBA_ORB_ptr, TEC_TypedConsumerAdmin_impl*,
                               CORBA_ULong);
    ~TEC_ProxyPushSupplier_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    virtual void connect_push_consumer(CosEventComm_PushConsumer_ptr);

    virtual void disconnect_push_supplier();

    //
    // Internal methods
    //

    //
    // Receive an event from the channel.
    //
    virtual void receive(Event_impl*);

    //
    // Called from the event channel upon destruction.
    //
    virtual void disconnect();

    //
    // Called to release this object reference.
    //
    virtual void release();

    CORBA_ULong proxyId() const { return id_; }
};

#endif
