// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_TYPED_CONSUMER_ADMIN_IMPL_H
#define COS_TYPED_CONSUMER_ADMIN_IMPL_H

//
// Forward declarations.
//
class ProxySupplier_impl;
typedef OBFixSeq<ProxySupplier_impl*> ProxySupplierPtrSeq;
class TEC_TypedEventChannel_impl;
class Event_impl;

//
// The event channel ConsumerAdmin class.
// 
class TEC_TypedConsumerAdmin_impl :
    public CosTypedEventChannelAdmin_TypedConsumerAdmin_skel,
    public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    TEC_TypedConsumerAdmin_impl(const TEC_TypedConsumerAdmin_impl&);
    void operator=(const TEC_TypedConsumerAdmin_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    TEC_TypedEventChannel_impl* channel_; // My event channel.

    ProxySupplierPtrSeq proxies_; // Set of proxy suppliers.

    CORBA_ULong nextId_; // The next proxy id.

    bool destroyed_; // Has this consumer been destroyed?
    
public:

    TEC_TypedConsumerAdmin_impl(CORBA_ORB_ptr, TEC_TypedEventChannel_impl*);
    ~TEC_TypedConsumerAdmin_impl();

    //
    // Standard IDL to C++ Mapping.
    //

    virtual CosEventChannelAdmin_ProxyPushSupplier_ptr
    obtain_push_supplier();

    virtual CosEventChannelAdmin_ProxyPullSupplier_ptr
    obtain_pull_supplier();

    virtual CosTypedEventChannelAdmin_TypedProxyPullSupplier_ptr
    obtain_typed_pull_supplier(const char*);

    virtual CosEventChannelAdmin_ProxyPushSupplier_ptr
    obtain_typed_push_supplier(const char*);
    
    //
    // Internal methods
    //
    
    //
    // Receive event from EventChannel.
    //
    void receive(Event_impl*);

    //
    // Remove this proxy from my list.
    //
    void removeProxy(ProxySupplier_impl*);

    //
    // Called from the event channel upon destruction.
    //
    void disconnect();
};

#endif
