// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_TYPED_PROXY_PUSH_SUPPLIER_IMPL_H
#define COS_TYPED_PROXY_PUSH_SUPPLIER_IMPL_H

//
// Forward declarations.
//
class TEC_TypedSupplierAdmin_impl;
class TEC_TypedEventChannel_impl;
class TypedProxyPushConsumerDSI_impl;

//
// The Event Channel ProxyPushConsumer implementation.
//
class TEC_TypedProxyPushConsumer_impl :
    public CosTypedEventChannelAdmin_TypedProxyPushConsumer_skel,
    public ProxyConsumer_impl,
    public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    TEC_TypedProxyPushConsumer_impl(const TEC_TypedProxyPushConsumer_impl&);
    void operator=(const TEC_TypedProxyPushConsumer_impl&);
    
    CORBA_ORB_var orb_; // The ORB.

    CosEventComm_PushSupplier_var supplier_; // My PushSupplier.

    TEC_TypedEventChannel_impl* channel_; // My event channel.

    TEC_TypedSupplierAdmin_impl* admin_; // My admin.

    ProxyState state_; // My state.

    TypedProxyPushConsumerDSI_impl* dsiImpl_; // The DSI implementation

    CORBA_String_var typeId_; // The typeid of the proxy

    CORBA_ULong id_; // My ID.

public:
    
    TEC_TypedProxyPushConsumer_impl(
        CORBA_ORB_ptr,
        TEC_TypedEventChannel_impl*,
        TEC_TypedSupplierAdmin_impl*,
        CORBA_InterfaceDef::FullInterfaceDescription*,
        CORBA_ULong);
    ~TEC_TypedProxyPushConsumer_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    virtual CORBA_Object_ptr get_typed_consumer();
    
    virtual void connect_push_supplier(CosEventComm_PushSupplier_ptr);
    
    virtual void disconnect_push_consumer();
    
    virtual void push(const CORBA_Any&);

    //
    // Internal methods.
    //

    //
    // Called from the event channel upon destruction.
    //
    virtual void disconnect();

    //
    // Called to release this object reference.
    //
    virtual void release();

    CORBA_ULong proxyId() const { return id_; }
};

#endif
