// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef TYPED_EVENT_CHANNEL_FACTORY_IMPL_H
#define TYPED_EVENT_CHANNEL_FACTORY_IMPL_H

//
// Forward declarations
//

class TEC_TypedEventChannel_impl;

template <class K, class T, class LS> class OBHashtable;

//
// The event channel factory implementation.
//
class TypedEventChannelFactory_impl
    : public OBTypedEventChannelFactory_TypedEventChannelFactory_skel,
      public JTCMonitor
{
    CORBA_ORB_var orb_; // The ORB.
    CORBA_BOA_var boa_; // The BOA.

    //
    // No copy constructor/assignment operator.
    //
    TypedEventChannelFactory_impl(const TypedEventChannelFactory_impl&);
    void operator=(const TypedEventChannelFactory_impl&);

public: // For some compilers this must be public
    typedef OBHashtable<CORBA_String_var, TEC_TypedEventChannel_impl*,
	                OB_LOCK_STRATEGY_SYNCHRONIZED> TypedEventChannelMap;

private:

    //
    // Mapping from CORBA_String_var to TEC_TypedEventChannel_impl*
    //
    TypedEventChannelMap* channels_;
    
public:

    TypedEventChannelFactory_impl(CORBA_ORB_ptr, CORBA_BOA_ptr);
    ~TypedEventChannelFactory_impl();

    //
    // Standard IDL to C++ Mapping.
    //

    //
    // Create TypedEventChannel object
    //
    virtual CosTypedEventChannelAdmin_TypedEventChannel_ptr create_channel(
	const char*);

    //
    // Get TypedEventChannel object by id
    //
    virtual CosTypedEventChannelAdmin_TypedEventChannel_ptr get_channel_by_id(
	const char*);

    //
    // Get TypedEventChannel object ids
    //
    virtual OBEventChannelFactory_ChannelIdSeq* get_channels();

    //
    // Shutdown the event service.
    //
    virtual void shutdown();

    //
    // Internal methods.
    //
    
    //
    // Remove Channel.
    //
    void removeChannel(const char*);
};

#endif
