// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef NAMING_LOGGER_H
#define NAMING_LOGGER_H

//
// Forward declarations
//
class NamingDatabase;

#ifdef HAVE_JTC
//
// This class is used to update the database journal on a regular
// basis.
//
class Logger : public JTCThread, public JTCMonitor
{
    NamingDatabase* store_;

    long interval_; // timeout interval
    bool stop_;

public:

    Logger(NamingDatabase*, long);

    void halt();

    virtual void run();
};

typedef JTCHandleT< Logger > LoggerHandle;

#else

//
// This class is used to update the database journal on a regular
// basis.
//
class Logger : public OBTimer
{
    NamingDatabase* store_;

    struct timeval interval_; // timeout interval

public:

    Logger(NamingDatabase*, long);

    virtual void notify();
};

typedef Logger* LoggerHandle;
#endif

#endif
