// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <OB/CosNaming.h>

#include "TestObject_impl.h"
#include "TestMacro.h"


//
// Test CosNaming::NamingContext::bind()
//
void
TestBind(CORBA_ORB_ptr orb, CosNaming_NamingContext_ptr root)
{
    TestObject_var test = new TestObject_impl;
    CosNaming_Name name1, name2;

    //
    // Test exceptions
    //

    try
    {
        //
        // Try to bind an object when an intermediate context
        // doesn't exist
        //
        name1.length(2);
        name1[0].id = CORBA_string_dup("bad");
        name1[0].kind = CORBA_string_dup("node");
        name1[1].id = CORBA_string_dup("my");
        name1[1].kind = CORBA_string_dup("node");
        root -> bind(name1, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::NotFound& ex)
    {
        assert(ex.why == CosNaming_NamingContext::missing_node);
    }

    name1.length(1);
    name1[0].id = CORBA_string_dup("object");
    name1[0].kind = CORBA_string_dup("");
    SUCCEED(root -> bind(name1, test));

    try
    {
        //
        // Try to bind an object when an object is in the path
        //
        name2.length(2);
        name2[0].id = CORBA_string_dup("object");
        name2[0].kind = CORBA_string_dup("");
        name2[1].id = CORBA_string_dup("my");
        name2[1].kind = CORBA_string_dup("node");
        root -> bind(name2, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::NotFound& ex)
    {
        assert(ex.why == CosNaming_NamingContext::not_context);
    }

    try
    {
        //
        // Try to bind an object to an existing name
        //
        root -> bind(name1, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::AlreadyBound&)
    {
        // expected
    }

    SUCCEED(root -> unbind(name1));

    try
    {
        //
        // Try to bind an object with an invalid name
        //
        name1.length(0);
        root -> bind(name1, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::InvalidName&)
    {
        // expected
    }

    try
    {
        //
        // Try to bind an object with an invalid name
        //
        name1.length(1);
        name1[0].id = CORBA_string_dup("");
        name1[0].kind = CORBA_string_dup("");
        root -> bind(name1, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::InvalidName&)
    {
        // expected
    }

    //
    // Bind an intermediate context for use in more tests
    //
    CosNaming_NamingContext_var context = root -> new_context();
    name1.length(1);
    name1[0].id = CORBA_string_dup("ctx");
    name1[0].kind = CORBA_string_dup("");
    SUCCEED(root -> bind_context(name1, context));

    try
    {
        //
        // Try to bind an object when an intermediate context
        // doesn't exist
        //
        name1.length(3);
        name1[0].id = CORBA_string_dup("ctx");
        name1[0].kind = CORBA_string_dup("");
        name1[1].id = CORBA_string_dup("bad");
        name1[1].kind = CORBA_string_dup("node");
        name1[2].id = CORBA_string_dup("my");
        name1[2].kind = CORBA_string_dup("node");
        root -> bind(name1, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::NotFound& ex)
    {
        assert(ex.why == CosNaming_NamingContext::missing_node);
    }

    name1.length(1);
    name1[0].id = CORBA_string_dup("object");
    name1[0].kind = CORBA_string_dup("");
    SUCCEED(context -> bind(name1, test));

    try
    {
        //
        // Try to bind an object when an object is in the path
        //
        name2.length(3);
        name2[0].id = CORBA_string_dup("ctx");
        name2[0].kind = CORBA_string_dup("");
        name2[1].id = CORBA_string_dup("object");
        name2[1].kind = CORBA_string_dup("");
        name2[2].id = CORBA_string_dup("my");
        name2[2].kind = CORBA_string_dup("node");
        root -> bind(name2, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::NotFound& ex)
    {
        assert(ex.why == CosNaming_NamingContext::not_context);
    }

    try
    {
        //
        // Try to bind an object to an existing name
        //
        name2.length(2);
        name2[0].id = CORBA_string_dup("ctx");
        name2[0].kind = CORBA_string_dup("");
        name2[1].id = CORBA_string_dup("object");
        name2[1].kind = CORBA_string_dup("");
        root -> bind(name2, test);
        assert("bind should not have succeeded" == 0);
    }
    catch(CosNaming_NamingContext::AlreadyBound&)
    {
        // expected
    }

    SUCCEED(context -> unbind(name1));

    //
    // Clean up context
    //
    name1.length(1);
    name1[0].id = CORBA_string_dup("ctx");
    name1[0].kind = CORBA_string_dup("");
    SUCCEED(root -> unbind(name1));
    SUCCEED(context -> destroy());


    //
    // Test name equality to make sure kind is included in comparisons
    //
    name1.length(1);
    name1[0].id = CORBA_string_dup("object");
    name1[0].kind = CORBA_string_dup("kind1");
    name2.length(1);
    name2[0].id = CORBA_string_dup("object");
    name2[0].kind = CORBA_string_dup("kind2");
    SUCCEED(root -> bind(name1, test));
    SUCCEED(root -> bind(name2, test));
    SUCCEED(root -> unbind(name1));
    SUCCEED(root -> unbind(name2));


    try
    {
	//
	// Try to bind a nil context
	//
	name1.length(1);
	name1[0].id = CORBA_string_dup("nil_ctx");
	name1[0].kind = CORBA_string_dup("");
	root -> bind_context(name1, CosNaming_NamingContext::_nil());
	assert("bind should not have succeeded" == 0);
    }
    catch(const CORBA_BAD_PARAM&)
    {
	// Expected
    }


    //
    // Test nil object 
    //
    name1.length(1);
    name1[0].id = CORBA_string_dup("nil_obj");
    name1[0].kind = CORBA_string_dup("");
    SUCCEED(root -> bind(name1, CORBA_Object::_nil()));
    SUCCEED(root -> unbind(name1));
}
