// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <assert.h>
#include <string.h>
#include "TestListener_impl.h"

TestListener_impl::TestListener_impl() :
    op_(TestListener_impl::OP_NONE), ctx_(CosNaming_NamingContext::_nil()),
    obj_(CORBA_Object::_nil()), valid_(false)
{
}

void
TestListener_impl::expect(TestListener_impl::Operation op,
                          CosNaming_NamingContext_ptr ctx,
			  CORBA_Object_ptr obj,
                          const CosNaming_NameComponent& name)

{
    op_ = op;
    ctx_ = CosNaming_NamingContext::_duplicate(ctx);
    obj_ = CORBA_Object::_duplicate(obj);
    name_ = name;
}

bool
TestListener_impl::isValid()
{
    if(valid_)
    {
	reset();
	return true;
    }
    else
	return false;
}

//
// CosNaming::BindingListener operations
//

void
TestListener_impl::context_added(CosNaming_NamingContext_ptr parent,
				 CosNaming_NamingContext_ptr child,
                                 const CosNaming_NameComponent& name)
{
    validate(CONTEXT_ADDED, parent, child, name);
}

void
TestListener_impl::context_removed(CosNaming_NamingContext_ptr parent,
                                   const CosNaming_NameComponent& name)
{
    validate(CONTEXT_REMOVED, parent, CORBA_Object::_nil(), name);
}

void
TestListener_impl::context_changed(CosNaming_NamingContext_ptr parent,
				   CosNaming_NamingContext_ptr child,
                                   const CosNaming_NameComponent& old_name,
				   const CosNaming_NameComponent& new_name)
{
    validate(CONTEXT_CHANGED, parent, child, new_name);
}

void
TestListener_impl::object_added(CosNaming_NamingContext_ptr parent,
				CORBA_Object_ptr child,
                                const CosNaming_NameComponent& name)
{
    validate(OBJECT_ADDED, parent, child, name);
}

void
TestListener_impl::object_removed(CosNaming_NamingContext_ptr parent,
                                  const CosNaming_NameComponent& name)
{
    validate(OBJECT_REMOVED, parent, CORBA_Object::_nil(), name);
}

void
TestListener_impl::object_changed(CosNaming_NamingContext_ptr parent,
				  CORBA_Object_ptr child,
                                  const CosNaming_NameComponent& old_name,
				  const CosNaming_NameComponent& new_name)
{
    validate(OBJECT_CHANGED, parent, child, new_name);
}

//
// Private functions
//

void
TestListener_impl::validate(TestListener_impl::Operation op,
                            CosNaming_NamingContext_ptr ctx,
			    CORBA_Object_ptr obj,
                            const CosNaming_NameComponent& name)
{
    assert(op_ == op);
    // The following assert is wrong, as in some cases ctx_ and ctx are
    // equivalent even though _is_equivalent() returns false.
    // assert(ctx_ -> _is_equivalent(ctx));
    if(!CORBA_is_nil(obj_))
	assert(obj_ -> _is_equivalent(obj));
    assert(equal(name_, name));
    valid_ = true;
}

bool
TestListener_impl::equal(const CosNaming_NameComponent& n1,
                         const CosNaming_NameComponent& n2)
{
    return(strcmp(n1.id, n2.id) == 0 && strcmp(n1.kind, n2.kind) == 0);
}

void
TestListener_impl::reset()
{
    op_ = OP_NONE;
    valid_ = false;
}
