// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef __TestListener_impl_h__
#define __TestListener_impl_h__

#include <OB/CORBA.h>
#include <OB/OBNaming_skel.h>

class TestListener_impl : virtual public CosNaming_BindingListener_skel
{
public:
    enum Operation
    {
	OP_NONE,
        CONTEXT_ADDED,
        CONTEXT_REMOVED,
        CONTEXT_CHANGED,
        OBJECT_ADDED,
        OBJECT_REMOVED,
        OBJECT_CHANGED
    };

    TestListener_impl();

    void expect(Operation op, CosNaming_NamingContext_ptr ctx,
		CORBA_Object_ptr obj, const CosNaming_NameComponent& name);

    bool isValid();

    //
    // CosNaming::BindingListener operations
    //

    virtual void context_added(CosNaming_NamingContext_ptr parent,
			       CosNaming_NamingContext_ptr child,
                               const CosNaming_NameComponent& name);

    virtual void context_removed(CosNaming_NamingContext_ptr parent,
                                 const CosNaming_NameComponent& name);

    virtual void context_changed(CosNaming_NamingContext_ptr parent,
				 CosNaming_NamingContext_ptr child,
                                 const CosNaming_NameComponent& old_name,
				 const CosNaming_NameComponent& new_name);

    virtual void object_added(CosNaming_NamingContext_ptr parent,
			      CORBA_Object_ptr child,
                              const CosNaming_NameComponent& name);

    virtual void object_removed(CosNaming_NamingContext_ptr parent,
                                const CosNaming_NameComponent& name);

    virtual void object_changed(CosNaming_NamingContext_ptr parent,
				CORBA_Object_ptr child,
                                const CosNaming_NameComponent& old_name,
				const CosNaming_NameComponent& new_name);

private:
    void validate(Operation op,
                  CosNaming_NamingContext_ptr ctx,
		  CORBA_Object_ptr obj,
                  const CosNaming_NameComponent& name);

    bool equal(const CosNaming_NameComponent& n1,
               const CosNaming_NameComponent& n2);

    void reset();

    Operation op_;
    CosNaming_NamingContext_var ctx_;
    CORBA_Object_var obj_;
    CosNaming_NameComponent name_;
    bool valid_;
};

#endif
