// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef __TestMacro_h__
#define __TestMacro_h__

#include <OB/CORBA.h>

#ifdef HAVE_IOSTREAM
#   include <iostream>
#else
#   include <iostream.h>
#endif

//
// This macro ensures that a statement which we expect to succeed
// actually DOES succeed. This is primarily intended to catch errors
// in the test suite itself.
//
#define SUCCEED(stmt) \
    try { \
        (stmt); \
    } catch (CORBA_UserException&) { \
        cerr << endl << "Unexpected user exception occurred during:" << endl; \
        cerr << endl << "  " << #stmt << endl; \
        cerr << endl << "At line " << __LINE__ << " in " << __FILE__ << endl; \
        exit(1); \
    }

#endif
