// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <OB/CosNaming.h>

#include "TestMacro.h"


//
// Test CosNaming_NamingContextExt::to_url()
//
void
TestToURL(CORBA_ORB_ptr orb, CosNaming_NamingContextExt_ptr root)
{
    CosNaming_NamingContextExt::Address_var addr;
    CosNaming_NamingContextExt::StringName_var name;
    CosNaming_NamingContextExt::URLString_var str;

    //
    // Test stringified names without URL escapes
    //
    addr = CORBA_string_dup("myhost.xyz.com");
    name = CORBA_string_dup("first.node");
    SUCCEED(str = root -> to_url(addr, name));
    assert(strcmp(str, "iiopname://myhost.xyz.com/first.node") == 0);

    addr = CORBA_string_dup("myhost.555.xyz.com,my_backup.555xyz.com:900");
    name = CORBA_string_dup("first.node");
    SUCCEED(str = root -> to_url(addr, name));
    assert(strcmp(str, "iiopname://myhost.555.xyz.com,"
		  "my_backup.555xyz.com:900/first.node") == 0);

    //
    // Test stringified names with URL escapes
    //
    addr = CORBA_string_dup("");
    name = CORBA_string_dup("<a>.b/c.d");
    SUCCEED(str = root -> to_url(addr, name));
    assert(strcmp(str, "iiopname:///%3Ca%3E.b/c.d") == 0);

    addr = CORBA_string_dup("");
    name = CORBA_string_dup("a.b/  c.d");
    SUCCEED(str = root -> to_url(addr, name));
    assert(strcmp(str, "iiopname:///a.b/%20%20c.d") == 0);

    addr = CORBA_string_dup("");
    name = CORBA_string_dup("a%b/c%d");
    SUCCEED(str = root -> to_url(addr, name));
    assert(strcmp(str, "iiopname:///a%25b/c%25d") == 0);
}
