// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <Hello.h>

main(int argc, char* argv[], char*[])
{
    try
    {
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);

	CORBA_Object_var obj =
	    orb -> get_inet_object("localhost", 12345, "DefaultHello");
	assert(!CORBA_is_nil(obj));
	
	Hello_var hello = Hello::_narrow(obj);
	assert(!CORBA_is_nil(hello));
	
	cout << "Enter 'h' for hello or 'x' for exit:\n";
	char c;
	do
	{
	    cout << "> ";
	    cin >> c;
	    if(c == 'h')
		hello -> hello();
	}
	while(c != 'x');
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return 1;
    }

    return 0;
}

