// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <OB/Properties.h>
#include <OB/NTService.h>

#include <HelloWorldService.h>

#include <HelloMsg.h>

#include <Hello_impl.h>

// ----------------------------------------------------------------------
// HelloWorldService constructor
// ----------------------------------------------------------------------

HelloWorldService::HelloWorldService()
    : OBNTService("HelloWorld", "Hello World Service", HELLO_MSG),
      stopped_(false)
{
}

// ----------------------------------------------------------------------
// HelloWorldService public member implementation
// ----------------------------------------------------------------------

void
HelloWorldService::start(int argc, char** argv)
{
    try
    {
	//
	// Create ORB and BOA
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);

        //
        // Set the port, and conc model properties for the BOA
        //
        OBProperties::instance() -> setProperty("ooc.boa.port", "12345");
        OBProperties::instance() -> setProperty("ooc.boa.conc_model",
					        "threaded");

        //
        // Create the BOA
        //
	boa_ = orb -> BOA_init(argc, argv);

        //
	// Create implementation object
	//
	Hello_var p = new Hello_impl;
	orb -> connect(p, "DefaultHello");

        //
        // Inform the status manager that the service is running.
        //
	statusUpdate(SERVICE_RUNNING);
        
	//
	// Run implementation
	//
        if(!stopped_)
            boa_ -> impl_is_ready(CORBA_ImplementationDef::_nil());
        boa_ = CORBA_BOA::_nil();
    }
    catch(CORBA_SystemException& ex)
    {
	CORBA_String_var err = OBExceptionToString(ex);
	OBMessageViewer::instance() -> error(err);
    }
}

void
HelloWorldService::stop()
{
    stopped_ = true;
    if(!CORBA_is_nil(boa_))
        boa_ -> deactivate_impl(CORBA_ImplementationDef::_nil());
}

