// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef CHAIN_IMPL_H
#define CHAIN_IMPL_H

#include <time.h>

#include <Chain_skel.h>

class Link_impl : public Link_skel
{
    CORBA_ORB_var orb_; // The ORB
    const char* file_; // File containing the IOR of the next link
    Link_var next_; // Next link
    bool master_; // Am I the master link in the chain
    long nextId_;  // Next message ID

#if defined(WIN32)
    clock_t startTime_; // Time of the start of the forward operation
#else
    double startTime_;
#endif
public:

    Link_impl(CORBA_ORB_ptr orb, const char* file);

    virtual void forward(const Message& msg);
    virtual void send(CORBA_Long nPings, CORBA_Long msgSize);

    virtual void close_loop();
};

#endif // CHAIN_IMPL_H
