// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <Chain.h>

#include <stdlib.h>
#include <errno.h>

#ifdef HAVE_FSTREAM
#   include <fstream>
#else
#   include <fstream.h>
#endif

int
main(int argc, char* argv[], char*[])
{
    try
    {
	//
	// Create ORB
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);
	
	if(argc < 4)
	{
	    cerr << argv[0] << ": master msgSize repetitions" << endl;
	    return EXIT_FAILURE;
	}
	//
	// Get "hello" object
	//
	const char* refFile = argv[1];
	ifstream in; // Must use open(name), not ifstream in(name) (VC++ bug)
	in.open(refFile);
	if(in.fail())
	{
	    cerr << argv[0] << ": can't open `" << refFile << "': "
		 << strerror(errno) << endl;
	    return EXIT_FAILURE;
	}
	
	char s[1000];
	in >> s;
	
	CORBA_Object_var obj = orb -> string_to_object(s);
	assert(!CORBA_is_nil(obj));
	
	Link_var link = Link::_narrow(obj);
	assert(!CORBA_is_nil(link));

	long msgSize = atol(argv[2]);
	cout << "msgSize is " << msgSize << endl;

	long reps = atol(argv[3]);
	cout << "repetitions are " << reps << endl;
	
	//
	// Close the chain.
	//
	link -> close_loop();

	//
	// Send msgSize messages reps times.
	//
	link -> send(reps, msgSize);
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return EXIT_FAILURE;
    }
    
    return EXIT_SUCCESS;
}


