// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <Chain_impl.h>

#include <stdlib.h>
#include <errno.h>

#ifdef HAVE_FSTREAM
#   include <fstream>
#else
#   include <fstream.h>
#endif

int
main(int argc, char* argv[], char*[])
{
    try
    {
	//
	// Create ORB and BOA
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);
	CORBA_BOA_var boa = orb -> BOA_init(argc, argv);
	
	if(argc < 3)
	{
	    cerr << argv[0] << ": mine next" << endl;
	    return EXIT_FAILURE;
	}
	const char* myRef = argv[1];
	const char* next = argv[2];

	//
	// Create implementation object
	//
	Link_var r = new Link_impl(orb, next);
	
	//
	// Save reference
	//
	CORBA_String_var s = orb -> object_to_string(r);
	
	ofstream out(myRef);
	if(out.fail())
	{
	    cerr << argv[0] << ": can't open `" << myRef << "': "
		 << strerror(errno) << endl;
	    return EXIT_FAILURE;
	}
	
	out << s << endl;
	out.close();
	
	//
	// Run implementation
	//
	boa -> impl_is_ready(CORBA_ImplementationDef::_nil());
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
