// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef SERVER_IMPL_H
#define SERVER_IMPL_H

#include <Broadcaster_skel.h>

class Broadcaster_impl : public Broadcaster_skel
{
    ReceiverDescSeq receiverDescSeq_;

    //
    // Add/remove receiver
    //
    void add(Receiver_ptr, const char*, const char*, const char*);
    void remove(Receiver_ptr);
    
public:

    Broadcaster_impl() { }

    //
    // Functions from the .idl file
    //
    virtual void _register(Receiver_ptr, const char*,
			   const char*, const char*);
    virtual void registerWithCheck(Receiver_ptr, const char*,
				   const char*, const char*);
    virtual void unregister(Receiver_ptr);
    virtual void getReceiverByNick(const char*, ReceiverDescription*&);
    virtual StringSeq* getReceiverNames();
    virtual void setNickName(Receiver_ptr, const char*);
    virtual void say(const char*);
};

#endif
