// WinClient.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"

#include "WinClient.h"

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <OB/Windows.h>

#include <Broadcaster.h>
#include <ReceiverBase_impl.h>

#include "WinClientDlg.h"
#include "WinClientServerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinClientApp

BEGIN_MESSAGE_MAP(CWinClientApp, CWinApp)
	//{{AFX_MSG_MAP(CWinClientApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinClientApp construction

CWinClientApp::CWinClientApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWinClientApp object

CWinClientApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CWinClientApp initialization

BOOL CWinClientApp::InitInstance()
{
    // CG: The following block was added by the Windows Sockets component.
    {
#ifndef _MAC
	if (!AfxSocketInit())
	{
	    AfxMessageBox(CG_IDS_SOCKETS_INIT_FAILED);
	    return FALSE;
	}
#endif  // _MAC
    }

    // Standard initialization
    // If you are not using these features and wish to reduce the size
    //  of your final executable, you should remove from the following
    //  the specific initialization routines you do not need.

#ifdef _AFXDLL
    Enable3dControls();			// Call this when using MFC in a shared DLL
#else
    Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

    CWinClientServerDlg serverDlg;
    int nResponse = serverDlg.DoModal();

    if (nResponse == IDOK)
    {
	const char* host = serverDlg.m_EditHost;
	const char* port = serverDlg.m_EditPort;
	CORBA_UShort portNum = atoi(serverDlg.m_EditPort);
	    
	try
	{
	    //
	    // Initialize the ORBacus library for use with windows
	    //
	    OBWindowsInit(m_hInstance);
		
	    //
	    // Create ORB and BOA
	    //
	    int dummy = 0;
	    CORBA_ORB_var orb = CORBA_ORB_init(dummy, 0);
	    CORBA_BOA_var boa = orb -> BOA_init(dummy, 0);

	    //
	    // Set the concurrency model
	    //
	    orb -> conc_model(CORBA_ORB::ConcModelReactive);
	    boa -> conc_model(CORBA_BOA::ConcModelReactive);
		
	    //
	    // Get "server" object
	    //
	    CORBA_Object_var obj =
		orb -> get_inet_object(host, portNum, "Chat-Server");
	    assert(!CORBA_is_nil(obj));
		
	    Broadcaster_var server = Broadcaster::_narrow(obj);
	    assert(!CORBA_is_nil(server));
		
	    //
	    // Initialize the servers so that incoming requests are
	    // handled from this point on
	    //
	    boa -> init_servers();

	    //
	    // Create receiver object
	    //
	    CWinClientDlg* dlg = new CWinClientDlg(server, m_pMainWnd);
	    Receiver_var receiver = dlg;
	    m_pMainWnd = dlg;
		
	    dlg -> DoModal();
	}
	catch(CORBA_SystemException& ex)
	{
	    OBPrintException(ex);
	}
    }

    // Since the dialog has been closed, return FALSE so that we exit the
    //  application, rather than start the application's message pump.
    return FALSE;
}
