// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef Factory_impl_h
#define Factory_impl_h

#include <Factory_skel.h>

//
// Forward declaration.
//
struct DBRecordData;

//
// The DBRecord_impl class
//
class DBRecord_impl : public DBRecord_skel
{
    DBRecordData* data_; // The actual data.
    long access_; // The time of last access.
public:
    DBRecord_impl(DBRecordData* data);

    CORBA_Long key();
    char* data();
    void data(const char* d);

    //
    // Return the key, but don't update the access time.
    //
    CORBA_Long internalKey();

    //
    // Get the time of last object access.
    //
    long access() const { return access_; }
};

typedef OBFixSeq<DBRecord_impl*> DBRecordImplPtrSeq;

//
// Forward declarations.
//
class DBReaper;
class Database;

//
// The DBFactory_impl class
//
class DBFactory_impl : public DBFactory_skel
{
    long nextKey_; // Next available key.
    Database* database_; // The database.
    DBRecordImplPtrSeq records_; // The loaded records.
    DBReaper* reaper_; // Database reaper.
    CORBA_ORB_var orb_; // The ORB.

    DBRecord_ptr makeRecord(DBRecordData* pos);
public:
    DBFactory_impl(CORBA_ORB_ptr orb);
    virtual ~DBFactory_impl();

    virtual DBRecord_ptr createRecord();
    virtual void destroyByKey(CORBA_Long key);
    virtual DBRecord_ptr getByKey(CORBA_Long key);
    virtual DBRecordKeySeq* getAllKeys();
};

#endif // Factory_impl_h
