// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/OCI_IIOP.h>

#include <Hello_impl.h>
#include <stdio.h>

Hello_impl::Hello_impl(OCI_Current_ptr current)
    : current_(OCI_Current::_duplicate(current))
{
}

void
Hello_impl::hello()
{
    cout << "Hello_impl::hello()" << endl;

    OCI_TransportInfo_var info = current_ -> get_oci_transport_info();
    OCI_IIOP_TransportInfo_var iiopInfo =
	OCI_IIOP_TransportInfo::_narrow(info);

    if(!CORBA_is_nil(iiopInfo))
    {
        OCI_IIOP_InetAddr_var remoteAddr = iiopInfo -> remote_addr();
        CORBA_UShort remotePort = iiopInfo -> remote_port();
        
	cout << "Call from: "
	     << (int)remoteAddr[0] << '.' << (int)remoteAddr[1] << '.'
	     << (int)remoteAddr[2] << '.' << (int)remoteAddr[3]
	     << ":" << remotePort << endl;
    }
}

