// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <OB/Timer.h>

#include <Nested_impl.h>

#include <stdlib.h>
#include <errno.h>

#ifdef HAVE_FSTREAM
#   include <fstream>
#else
#   include <fstream.h>
#endif

int
main(int argc, char* argv[], char*[])
{
    try
    {
	//
	// Create ORB and BOA
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);
	CORBA_BOA_var boa = orb -> BOA_init(argc, argv);

	//
	// Get nesting level
	//
	if(argc < 2)
	{
	    cerr << "Usage: " << argv[0] << " nesting-level" << endl;
	    return 1;
	}
	int level = atoi(argv[1]);
	if(level <= 0 || (level % 2) == 1)
	{
	    cerr << argv[0]
		 << ": nesting level must be positive and even"
		 << endl;
	    return 1;
	}
	
	//
	// Get "I" object
	//
	const char* refFile = "I.ref";
	ifstream in; // Must use open(name), not ifstream in(name) (VC++ bug)
	in.open(refFile);
	if(in.fail())
	{
	    cerr << argv[0] << ": can't open `" << refFile << "': "
		 << strerror(errno) << endl;
	    return 1;
	}
	
	char s[1000];
	in >> s;
	
	CORBA_Object_var obj = orb -> string_to_object(s);
	assert(!CORBA_is_nil(obj));
	
	I_var i = I::_narrow(obj);
	assert(!CORBA_is_nil(i));
	
	//
	// Create implementation object
	//
	// We divide level by two since we want this to be the
	// nesting level of the servers.
	//
	I_var p = new I_impl(i, level / 2);

	//
	// Initialize the servers so that incoming requests are
	// handled from this point on
	//
	boa -> init_servers();

	//
	// Tell i to call back into the implementation object p.
	//
	// This also has the side effect of forcing the thread pool to
	// be initialized (if the server is, in fact, using a thread
	// pool)
        //
	timeval tv = OBTimerList::timeNow();
	i -> connect(p);
	tv = OBTimerList::timeSub(OBTimerList::timeNow(), tv);
	cout << "Time needed for initialization: "
	     << ((double)tv.tv_sec + (double)tv.tv_usec / 1000000.0) * 1000.0
 	     << " ms" << endl;

	//
	// Run the performance test
	//
	tv = OBTimerList::timeNow();
	i -> f();
	tv = OBTimerList::timeSub(OBTimerList::timeNow(), tv);
	cout << "Total time needed: "
	     << ((double)tv.tv_sec + (double)tv.tv_usec / 1000000.0) * 1000.0
             << " ms" << endl;
	cout << "Time per method call: "
	     << (((double)tv.tv_sec + (double)tv.tv_usec / 1000000.0)
		/ (double)level) * 1000.0 << " ms" << endl;
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return 1;
    }

    return 0;
}

