// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <Interface.h>

#include <stdlib.h>
#include <errno.h>

#ifdef HAVE_FSTREAM
#   include <fstream>
#else
#   include <fstream.h>
#endif

int
main(int argc, char* argv[], char*[])
{
    try
    {
	//
	// Create ORB
	//
	CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);
	
	//
	// Get "interface" object
	//
	const char* refFile = "Interface.ref";
	ifstream in; // Must use open(name), not ifstream in(name) (VC++ bug)
	in.open(refFile);
	if(in.fail())
	{
	    cerr << argv[0] << ": can't open `" << refFile << "': "
		 << strerror(errno) << endl;
	    return 1;
	}
	
	char s[1000];
	in >> s;
	
	CORBA_Object_var obj = orb -> string_to_object(s);
	assert(!CORBA_is_nil(obj));
	
	Module_Interface_var interf = Module_Interface::_narrow(obj);
	assert(!CORBA_is_nil(interf));
	
	//
	// Print interface repository content
	//
	CORBA_InterfaceDef_var idef = interf -> _get_interface();
	if(CORBA_is_nil(idef))
	{
	    cerr << argv[0] << ": no interface repository available" << endl;
	    return 1;
	}
	else
	{
	    CORBA_InterfaceDef::FullInterfaceDescription_var desc =
		idef -> describe_interface();

	    CORBA_ULong i;

	    cout << "name = " << desc -> name << endl;
	    cout << "id = " << desc -> id << endl;
	    cout << "defined_in = " << desc -> defined_in << endl;
	    cout << "version = " << desc -> version << endl;
	    cout << "operations:" << endl;
	    for(i = 0 ; i < desc -> operations.length() ; i++)
	    {
		cout << i << ": " << desc -> operations[i].name << endl;
	    }
	    cout << "attributes:" << endl;
	    for(i = 0 ; i < desc -> attributes.length() ; i++)
	    {
		cout << i << ": " << desc -> attributes[i].name << endl;
	    }
	    cout << "base_interfaces:" << endl;
	    for(i = 0 ; i < desc -> base_interfaces.length() ; i++)
	    {
		cout << i << ": " << desc -> base_interfaces[i] << endl;
	    }
	}
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	return 1;
    }
    
    return 0;
}

