// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_ENVIRONMENT_H
#define OB_ENVIRONMENT_H

//
// The Environment class
//
class CORBA_Environment;
typedef CORBA_Environment* CORBA_Environment_ptr;
typedef CORBA_Environment_ptr EnvironmentRef;
void OBDuplicate(CORBA_Environment_ptr);
void OBRelease(CORBA_Environment_ptr);
typedef OBObjVar< CORBA_Environment > CORBA_Environment_var;

class CORBA_Environment : public OBRefCount
{
    //
    // The exception
    //
    CORBA_Exception* exception_;

    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_Environment(const CORBA_Environment&);
    void operator=(const CORBA_Environment&);

protected:

    CORBA_Environment();
    virtual ~CORBA_Environment();

    friend class CORBA_ORB; // ORBs may create Enviroments
    friend class CORBA_Request; // Requests may create Enviroments

public:

    //
    // Standard IDL to C++ Mapping
    //
    static inline CORBA_Environment_ptr _duplicate(CORBA_Environment_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline CORBA_Environment_ptr _nil()
    { return 0; }

    void exception(CORBA_Exception*);
    CORBA_Exception* exception() const;
    void clear() { exception(0); }
};

inline void
CORBA_release(CORBA_Environment_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline CORBA_Boolean
CORBA_is_nil(CORBA_Environment_ptr p)
{
    return p == 0;
}

#endif
