// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_INS_H
#define OB_INS_H

//
// This class parses the fields of an IIOPNAME stringified name. Pass
// as string or octet sequence to the constructor. The isValid()
// method determines if the path is a valid stringified name. The
// getContents() method returns a string sequence of {id, kind} pairs.
//
class OBIIOPNameParser
{
    OBFixSeq<CORBA_Octet> path_;
    CORBA_ULong curr_;
    char terminator_;

    OBStrSeq contents_;
    bool valid_;

    char* next();

    bool atEnd() const;

    char terminator() const;

    void parse();
    
public:

    OBIIOPNameParser(const OBFixSeq<CORBA_Octet>&);
    OBIIOPNameParser(const char*);

    bool isValid() const;

    const OBStrSeq& getContents() const;
};

#endif
