// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef NT_SERVICE_H
#define NT_SERVICE_H

//
// This class represents an NT service.
//
class OBNTService
{
    static OBNTService* instance_; // The one and only instance
    
    CORBA_String_var name_; // The name
    CORBA_String_var title_; // The title
    bool debug_; // Are we debugging?
    DWORD checkPoint_; // Check point value
    SERVICE_STATUS status_; // Status of the service
    SERVICE_STATUS_HANDLE statusHandle_; // Status handle
    bool useEventViewer_; // Do we use the NTEventViewer?
    DWORD eventId_; // If so what ID are the events logged with?

    //
    // Subclasses must override start.
    //
    virtual void start(int, char**) = 0;

    void control(DWORD);
    void main(int argc, char** argv);

    //
    // Callback for service control
    //
    friend void WINAPI _OB_serviceCtrl(DWORD);

    //
    // Callback for service creation
    //
    friend void WINAPI _OB_serviceMain(DWORD, LPTSTR*);
    
protected:

    //
    // This must be called to update the NT service manager on the
    // state of this service.
    //
    void statusUpdate(DWORD, DWORD = NO_ERROR, DWORD = 0);

public:

    OBNTService(const char* name, const char* title);
    OBNTService(const char* name, const char* title, DWORD eventID);

    virtual ~OBNTService();

    //
    // Get the service instance.
    //
    static OBNTService* instance();

    //
    // Install the service.
    //
    bool install();

    //
    // Uninstall the service.
    //
    bool uninstall();

    //
    // Run the service. This will invoke start() to start the service.
    //
    void run(int, char**);

    //
    // Subclasses must override stop.
    //
    virtual void stop() = 0;

    //
    // Get/set for debug
    //
    void setDebug() { debug_ = true; }
    bool getDebug() const { return debug_; }
};

#endif
