// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_OBJECT_SKEL_H
#define OB_OBJECT_SKEL_H

//
// The Object skeleton class
//
class CORBA_Object_skel : public virtual CORBA_Object
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_Object_skel(const CORBA_Object_skel&);
    void operator=(const CORBA_Object_skel&);

protected:

    CORBA_Object_skel() { }

public:

    //
    // Standard IDL to C++ Mapping
    //
    CORBA_Object_ptr _this() { return CORBA_Object::_duplicate(this); }
    CORBA_BOA_ptr _boa();
    virtual CORBA_ImplementationDef_ptr _get_implementation();
    virtual CORBA_InterfaceDef_ptr _get_interface();
    virtual CORBA_Boolean _non_existent();

    //
    // Additional ORBacus specific functions
    //
    virtual CORBA_Boolean _is_dynamic();
    
    //
    // ORBacus internal functions
    // Application programs must not use these functions directly
    //
    virtual OBDispatchStatus _OB_dispatch(const char*, OBBuffer&, bool,
					  CORBA_ULong, CORBA_ULong);
    CORBA_Long _OB_findOperation(const char*,
                                 const char*[],
                                 CORBA_ULong);
};

#endif

