// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_REACTOR_H
#define OB_REACTOR_H

//
// Event handler handle
// The event mask
// The event types
//
typedef int OBHandle;
typedef CORBA_ULong OBMask;
const OBMask OBEventRead = 0x1;
const OBMask OBEventWrite = 0x2;

//
// The OBEventHandler class
//
class OBEventHandler
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBEventHandler(const OBEventHandler&);
    void operator=(const OBEventHandler&);

protected:

    OBEventHandler() { }
    virtual ~OBEventHandler() { }

public:

    //
    // Handle event
    //
    virtual void handleEvent(OBMask) = 0;
};

//
// The OBReactor base class
//
class OBReactor
{
    //
    // Hide copy-constructor and asignment operator
    //
    OBReactor(const OBReactor&);
    void operator=(const OBReactor&);

protected:

    //
    // The Reactor singleton
    //
    static OB_IMPORT OBReactor* instance_;
    friend class OBReactorDestroyer;

    OBReactor() { }
    virtual ~OBReactor() { }

public:

    //
    // Get the reactor singleton
    //
    static OBReactor* instance();

    //
    // Register and unregister event handler
    //
    virtual void registerHandler(OBEventHandler*, OBMask, OBHandle) = 0;
    virtual void unregisterHandler(OBEventHandler*) = 0;

    //
    // Dispatch events
    //
    virtual void dispatch() = 0;
    virtual bool dispatchOneEvent(CORBA_Long) = 0;

    //
    // Stop event dispatching
    //
    virtual void stop() = 0;
};

#endif
