// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

//
// Author: Philippe Merle
//
// From the Laboratoire d'Informatique Fondamentale de Lille in France
// (it is a computer science laboratory of the Lille french university)
//

#ifndef OB_DYN_ANY_IMPL_H
#define OB_DYN_ANY_IMPL_H

#include <OB/Narrow_impl.h>  // for narrowing CORBA_DynAny to subclasses

// ----------------------------------------------------------------------
//
// The DynAny implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynAny_impl : virtual public CORBA_DynAny
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynAny_impl(const CORBA_DynAny_impl&);
    void operator=(const CORBA_DynAny_impl&);

protected: // internal state

    CORBA_TypeCode_var type_;           // The TypeCode

protected: // constructor and destructor

    CORBA_DynAny_impl(CORBA_TypeCode_ptr);
    virtual ~CORBA_DynAny_impl();

    // create a CORBA_DynAny_impl from a CORBA_TypeCode
    static CORBA_DynAny_impl* create (CORBA_TypeCode_ptr typecode);

    // The ORB calls the previous function
    friend class CORBA_ORB;

public: // operations to access components

    virtual CORBA_Any* current_any () =0;
    virtual CORBA_Any* current_any_value () =0;

public: // operations to marshal and unmarshal components
        // into a complex any value

    virtual void MarshalCount(CORBA_ULong& count) =0;
    virtual void Marshal (CORBA_Octet*& oct) =0;
    virtual void Unmarshal (const CORBA_Octet*& coct) =0;

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //

    CORBA_TypeCode_ptr type();

    void insert_boolean(CORBA_Boolean value);
    void insert_octet(CORBA_Octet value);
    void insert_char(CORBA_Char value);
    void insert_short(CORBA_Short value);
    void insert_ushort(CORBA_UShort value);
    void insert_long(CORBA_Long value);
    void insert_ulong(CORBA_ULong value);
    void insert_float(CORBA_Float value);
    void insert_double(CORBA_Double value);
    void insert_string(const char* value);
    void insert_reference(CORBA_Object_ptr value);
    void insert_typecode(CORBA_TypeCode_ptr value);
    void insert_any(const CORBA_Any& value);

    CORBA_Boolean get_boolean();
    CORBA_Octet get_octet();
    CORBA_Char get_char();
    CORBA_Short get_short();
    CORBA_UShort get_ushort();
    CORBA_Long get_long();
    CORBA_ULong get_ulong();
    CORBA_Float get_float();
    CORBA_Double get_double();
    char* get_string();
    CORBA_Object_ptr get_reference();
    CORBA_TypeCode_ptr get_typecode();
    CORBA_Any* get_any();

    // these operations are defined into subclasses
    //
    virtual void assign(CORBA_DynAny_ptr dyn_any) =0;
    virtual void from_any(const CORBA_Any& value) =0;
    virtual CORBA_Any* to_any() =0;
    virtual void destroy() =0;
    virtual CORBA_DynAny_ptr copy() =0;

    virtual CORBA_DynAny_ptr current_component() =0;
    virtual CORBA_Boolean next() =0;
    virtual CORBA_Boolean seek(CORBA_Long index) =0;

    virtual void rewind() =0;

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynAny_impl)
};

// ----------------------------------------------------------------------
//
// The DynBasic implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynBasic_impl : virtual public CORBA_DynAny_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynBasic_impl(const CORBA_DynBasic_impl&);
    void operator=(const CORBA_DynBasic_impl&);

protected: // internal state

    CORBA_Any_var any_; // The Any value for basic TypeCodes

protected: // constructor and destructor

    // The CORBA_ORB and CORBA_DynAny_impl may create CORBA_DynBasic_impls
    friend class CORBA_ORB;
    friend class CORBA_DynAny_impl;

    CORBA_DynBasic_impl(CORBA_TypeCode_ptr);
    virtual ~CORBA_DynBasic_impl();

protected: // operations to access components

   CORBA_Any* current_any ();
   CORBA_Any* current_any_value ();

protected: // operations to marshal and unmarshal components
           // into a complex any value

   void MarshalCount(CORBA_ULong& count);
   void Marshal (CORBA_Octet*& oct);
   void Unmarshal (const CORBA_Octet*& coct);

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    void assign(CORBA_DynAny_ptr dyn_any);
    void from_any(const CORBA_Any& value);
    CORBA_Any* to_any();
    void destroy();
    CORBA_DynAny_ptr copy();

    CORBA_DynAny_ptr current_component();
    CORBA_Boolean next();
    CORBA_Boolean seek(CORBA_Long index);
    void rewind();

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynBasic_impl)
};

// ----------------------------------------------------------------------
//
// The DynEnum implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynEnum_impl : virtual public CORBA_DynEnum,
			   virtual public CORBA_DynAny_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynEnum_impl(const CORBA_DynEnum_impl&);
    void operator=(const CORBA_DynEnum_impl&);

protected: // internal state

    CORBA_ULong value_; // the enum value

protected: // constructor and destructor

    // The CORBA_ORB and CORBA_DynAny_impl may create CORBA_DynEnum_impls
    friend class CORBA_ORB;
    friend class CORBA_DynAny_impl;

    CORBA_DynEnum_impl(CORBA_TypeCode_ptr, CORBA_ULong value = 0);
    virtual ~CORBA_DynEnum_impl();

protected: // operations to access components

   CORBA_Any* current_any ();
   CORBA_Any* current_any_value ();

protected: // operations to marshal and unmarshal components
           // into a complex any value

   void MarshalCount(CORBA_ULong& count);
   void Marshal (CORBA_Octet*& oct);
   void Unmarshal (const CORBA_Octet*& coct);

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    void assign(CORBA_DynAny_ptr dyn_any);
    void from_any(const CORBA_Any& value);
    CORBA_Any* to_any();
    void destroy();
    CORBA_DynAny_ptr copy();

    CORBA_DynAny_ptr current_component();
    CORBA_Boolean next();
    CORBA_Boolean seek(CORBA_Long index);
    void rewind();

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynEnum interface
    //
    char* value_as_string();
    void value_as_string(const char*);
    CORBA_ULong value_as_ulong();
    void value_as_ulong(CORBA_ULong);

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynEnum_impl)
};

// ----------------------------------------------------------------------
//
// The DynComplex implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynComplex_impl : virtual public CORBA_DynAny_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynComplex_impl(const CORBA_DynComplex_impl&);
    void operator=(const CORBA_DynComplex_impl&);

protected: // internal state

    CORBA_DynAnySeq components_; // sequence of components
    CORBA_ULong index_;          // current component

protected: // constructor and destructor

    CORBA_DynComplex_impl(CORBA_TypeCode_ptr);
    virtual ~CORBA_DynComplex_impl();

protected: // operation to init components sequence

   void init_components(CORBA_ULong);

protected: // operations to access components

   CORBA_Any* current_any ();
   CORBA_Any* current_any_value ();

protected: // operations to marshal and unmarshal components
           // into a complex any value

   void MarshalCount(CORBA_ULong& count);
   void Marshal (CORBA_Octet*& oct);
   void Unmarshal (const CORBA_Octet*& coct);

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    void assign(CORBA_DynAny_ptr dyn_any);
    void from_any(const CORBA_Any& value);
    CORBA_Any* to_any();
    void destroy();

    CORBA_DynAny_ptr current_component();
    CORBA_Boolean next();
    CORBA_Boolean seek(CORBA_Long index);
    void rewind();

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynComplex_impl)
};

// ----------------------------------------------------------------------
//
// The DynStruct implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynStruct_impl : virtual public CORBA_DynStruct,
			     virtual public CORBA_DynComplex_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynStruct_impl(const CORBA_DynStruct_impl&);
    void operator=(const CORBA_DynStruct_impl&);

protected: // internal state

protected: // constructor and destructor

    // The CORBA_ORB and CORBA_DynAny_impl may create CORBA_DynStruct_impls
    friend class CORBA_ORB;
    friend class CORBA_DynAny_impl;

    CORBA_DynStruct_impl(CORBA_TypeCode_ptr, CORBA_Boolean init = CORBA_TRUE);
    virtual ~CORBA_DynStruct_impl();

protected: // operations to marshal and unmarshal components
           // into a complex any value

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    CORBA_DynAny_ptr copy();

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynStruct interface
    //
    CORBA_FieldName current_member_name();
    CORBA_TCKind current_member_kind();
    CORBA_NameValuePairSeq* get_members();
    void set_members(const CORBA_NameValuePairSeq& value);

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynStruct_impl)
};

// ----------------------------------------------------------------------
//
// The DynException implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynException_impl :  virtual public CORBA_DynStruct_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynException_impl(const CORBA_DynException_impl&);
    void operator=(const CORBA_DynException_impl&);

protected: // internal state

    const char* id_;

protected: // constructor and destructor

    // The CORBA_ORB and CORBA_DynAny_impl may create CORBA_DynException_impls
    friend class CORBA_ORB;
    friend class CORBA_DynAny_impl;

    CORBA_DynException_impl(CORBA_TypeCode_ptr, CORBA_Boolean init = CORBA_TRUE);
    virtual ~CORBA_DynException_impl();

protected: // operations to marshal and unmarshal components
           // into a complex any value

   void MarshalCount(CORBA_ULong& count);
   void Marshal (CORBA_Octet*& oct);
   void Unmarshal (const CORBA_Octet*& coct);

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    CORBA_DynAny_ptr copy();

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynException_impl)
};

// ----------------------------------------------------------------------
//
// The DynUnion implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynUnion_impl : virtual public CORBA_DynUnion,
			    virtual public CORBA_DynComplex_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynUnion_impl(const CORBA_DynUnion_impl&);
    void operator=(const CORBA_DynUnion_impl&);

protected: // internal state

    OBFixSeq<CORBA_Long> member_labels_;
    OBObjSeq<CORBA_TypeCode> member_types_;
    CORBA_Long default_index_; // = -1 if no default or index in members

    CORBA_Long current_discr_index_;

protected: // constructor and destructor

    // The CORBA_ORB and CORBA_DynAny_impl may create CORBA_DynUnion_impls
    friend class CORBA_ORB;
    friend class CORBA_DynAny_impl;

    CORBA_DynUnion_impl(CORBA_TypeCode_ptr);
    virtual ~CORBA_DynUnion_impl();

protected: // private operations

    void check_discriminator_and_set_member ();

    void set_dyn_any (CORBA_DynAny_ptr dyn_any, CORBA_Long);

    CORBA_Long compute_any (CORBA_Any* any);

    CORBA_Long compute_default_value (CORBA_TypeCode_ptr);

protected: // operations to marshal and unmarshal components
           // into a complex any value

   void Unmarshal (const CORBA_Octet*& coct);

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    void assign(CORBA_DynAny_ptr dyn_any);
    CORBA_DynAny_ptr copy();

    CORBA_Boolean next();

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynUnion interface
    //
    CORBA_Boolean set_as_default();
    void set_as_default(CORBA_Boolean);
    CORBA_DynAny_ptr discriminator();
    CORBA_TCKind discriminator_kind();
    CORBA_DynAny_ptr member();
    CORBA_FieldName member_name();
    void member_name(const char*);
    CORBA_TCKind member_kind();

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynUnion_impl)
};

// ----------------------------------------------------------------------
//
// The DynSequence implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynSequence_impl : virtual public CORBA_DynSequence,
			       virtual public CORBA_DynComplex_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynSequence_impl(const CORBA_DynSequence_impl&);
    void operator=(const CORBA_DynSequence_impl&);

protected: // internal state

protected: // constructor and destructor

    // The CORBA_ORB and CORBA_DynAny_impl may create CORBA_DynSequence_impls
    friend class CORBA_ORB;
    friend class CORBA_DynAny_impl;

    CORBA_DynSequence_impl(CORBA_TypeCode_ptr);
    virtual ~CORBA_DynSequence_impl();

protected:

   void init_components (CORBA_ULong);

protected: // operations to marshal and unmarshal components
           // into a complex any value

   void MarshalCount(CORBA_ULong& count);
   void Marshal (CORBA_Octet*& oct);
   void Unmarshal (const CORBA_Octet*& coct);

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    void assign(CORBA_DynAny_ptr dyn_any);
    CORBA_DynAny_ptr copy();

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynSequence
    //
    CORBA_ULong length();
    void length(CORBA_ULong);
    CORBA_AnySeq* get_elements();
    void set_elements(const CORBA_AnySeq& value);

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynSequence_impl)
};

// ----------------------------------------------------------------------
//
// The DynArray implementation class
//
// ----------------------------------------------------------------------
class CORBA_DynArray_impl : virtual public CORBA_DynArray,
			    virtual public CORBA_DynComplex_impl
{
    //
    // Hide copy-constructor and asignment operator
    //
    CORBA_DynArray_impl(const CORBA_DynArray_impl&);
    void operator=(const CORBA_DynArray_impl&);

protected: // internal state

protected: // constructor and destructor

    // The CORBA_ORB and CORBA_DynAny_impl may create CORBA_DynSequence_impls
    friend class CORBA_ORB;
    friend class CORBA_DynAny_impl;

    CORBA_DynArray_impl(CORBA_TypeCode_ptr, CORBA_Boolean init = CORBA_TRUE);
    virtual ~CORBA_DynArray_impl();

protected: // operations to marshal and unmarshal components
           // into a complex any value

public: // public IDL operations

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynAny interface
    //
    CORBA_DynAny_ptr copy();

    //
    // Standard IDL to C++ Mapping
    // from CORBA_DynArray interface
    //
    CORBA_AnySeq* get_elements();
    void set_elements(const CORBA_AnySeq& value);

public: // for narrowing instances

    OB_MAKE_NARROW_IMPL (CORBA_DynArray_impl)
};

#endif

// ----------------------------------------------------------------------
// end of DynAny_impl.h file
// ----------------------------------------------------------------------
