// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Except.h>
#include <OB/Template.h>
#include <OB/TemplateI.h>
#include <OB/Environment.h>

// ----------------------------------------------------------------------
// External, non-inline duplicate/release for templates
// ----------------------------------------------------------------------

void
OBDuplicate(CORBA_Environment_ptr p)
{
    if(p)
	p -> _OB_incRef();
}

void
OBRelease(CORBA_Environment_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

// ----------------------------------------------------------------------
// Template instantiations
// ----------------------------------------------------------------------

#ifndef HAVE_NO_EXPLICIT_TEMPLATES
template class OBObjVar< CORBA_Environment >;
template class OBObjForSeq< CORBA_Environment >;
template class OBObjSeq< CORBA_Environment >;
template class OBSeqVar< OBObjSeq< CORBA_Environment > >;
#else
#ifdef HAVE_PRAGMA_DEFINE
#pragma define(OBObjVar< CORBA_Environment >)
#pragma define(OBObjForSeq< CORBA_Environment >)
#pragma define(OBObjSeq< CORBA_Environment >)
#pragma define(OBSeqVar< OBObjSeq< CORBA_Environment > >)
#endif
#endif

// ----------------------------------------------------------------------
// Environment constructor and destructor
// ----------------------------------------------------------------------

CORBA_Environment::CORBA_Environment()
    : exception_(0)
{
}

CORBA_Environment::~CORBA_Environment()
{
    delete exception_;
}

// ----------------------------------------------------------------------
// Environment public member implementation
// ----------------------------------------------------------------------

void
CORBA_Environment::exception(CORBA_Exception* p)
{
    delete exception_;
    exception_ = p;
}

CORBA_Exception*
CORBA_Environment::exception() const
{
    return exception_;
}
