# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..\..

NAME		= $(top_srcdir)\lib\ob.lib

PDB_NAME	= $(top_srcdir)\lib\ob.pdb

TARGETS		= $(NAME)

!include $(top_srcdir)\config\Make.rules.mak

IDLDIR		= $(top_srcdir)\idl
HDIR		= $(top_srcdir)\include\OB
TDIR		= ..\translator

# Support for ORBacus servers as native NT services is only available
# with JThreads/C++
!if "$(WITH_JTC)" == "yes"
OBJS_NTSERVICE	= NTService.obj
!else
OBJS_NTSERVICE	= 
!endif

OBJS		= Basic.obj \
		  Except.obj \
		  Sequence.obj \
		  Any.obj \
		  TCKind.obj \
		  Dynamic.obj \
		  TypeCode.obj \
		  Environment.obj \
		  Context.obj \
		  NamedValue.obj \
		  Principal.obj \
		  IOP.obj \
		  Object.obj \
		  Policy.obj \
		  PolicyManager.obj \
		  PolicyValidator.obj \
		  ORBPolicyManager_impl.obj \
		  OBPolicies.obj \
		  OBPolicies_impl.obj \
		  IntRep.obj \
		  IntRepMember.obj \
		  ORB.obj \
		  INS.obj \
		  Object_skel.obj \
		  ImplRep.obj \
		  BOA.obj \
		  Hashers.obj \
		  DII.obj \
		  DSI.obj \
		  Current.obj \
		  DynAny.obj \
		  DynAny_impl.obj \
		  Timer.obj \
		  SelectReactor.obj \
		  GIOP.obj \
		  GIOPClient.obj \
		  GIOPClientWorker.obj \
		  GIOPServer.obj \
		  GIOPServerStarter.obj \
		  GIOPServerWorker.obj \
		  IIOP.obj \
		  IIOPInit.obj \
		  OCIBuffer.obj \
		  OCI.obj \
		  OCI_impl.obj \
		  OCI_IIOP.obj \
		  OCI_IIOP_impl.obj \
		  Net.obj \
		  Util.obj \
		  Properties.obj \
		  License.obj \
		  WinReactor.obj \
		  $(OBJS_NTSERVICE)

# Also in non-DLL mode needed for the clean target
DEF_NAME	= ob.def
DLL_NAME	= $(top_srcdir)\lib\ob.dll
EXP_NAME	= $(top_srcdir)\lib\ob.exp

!if "$(DLL)" == "yes"

ALL_CXXFLAGS	= $(CXXFLAGS) /Fd$(PDB_NAME)
ALL_CPPFLAGS	= /DOB_BUILD_DLL /I. $(OB_CPPFLAGS) $(CPPFLAGS)
ALL_DLLLIBS	= $(OB_DLLLIBS) $(DLLLIBS)

$(NAME): $(DLL_NAME)

$(DEF_NAME):

$(DLL_NAME): $(OBJS) $(DEF_NAME)
	perl $(top_srcdir)\..\config\makedef.pl $(DEF_NAME) OB $(OBJS)
	$(LINK) $(LINKDLLFLAGS) /def:$(DEF_NAME) /out:$@ $(OBJS) $(ALL_DLLLIBS)

!else

ALL_CXXFLAGS	= $(CXXFLAGS) /Fd$(PDB_NAME)
ALL_CPPFLAGS	= /I. $(OB_CPPFLAGS) $(CPPFLAGS)

$(NAME): $(OBJS)
	$(AR) $(ARFLAGS) /out:$@ $(OBJS)

!endif

$(top_srcdir)\include\OB\WinConfig.h: $(top_srcdir)\..\config\WinConfig.h
	copy $(top_srcdir)\..\config\WinConfig.h $@

$(top_srcdir)\include\OB\Config.h: $(top_srcdir)\include\OB\WinConfig.h \
				   $(top_srcdir)\..\config\Make.rules.mak
	del $@
!if "$(WITH_JTC)" == "yes"
	echo #define HAVE_JTC 1 >> $@
!else
	echo /* #undef HAVE_JTC */ >> $@
!endif
!if "$(DLL)" == "yes"
	echo #define OB_DLL 1 >> $@
!else
	echo /* #undef OB_DLL */ >> $@
!endif
!if "$(OLD_IOSTREAM)" != "yes"
	echo #define HAVE_IOSTREAM 1 >> $@
!else
	echo /* #undef HAVE_IOSTREAM */ >> $@
!endif
	echo #include "WinConfig.h" >> $@

clean::
	del $(top_srcdir)\include\OB\Config.h

IntRepMember.cpp $(HDIR)\IntRepMember.h: $(IDLDIR)\IntRepMember.idl
	if exist $(IDL) \
	    del IntRepMember.cpp $(HDIR)\IntRepMember.h & \
	    del $(TDIR)\IntRepMember_skel.cpp & \
	    del $(HDIR)\IntRepMember_skel.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB \
	    --dll-import OB_IMPORT $(IDLDIR)\IntRepMember.idl & \
	    move IntRepMember.h $(HDIR) & \
	    move IntRepMember_skel.h $(HDIR) & \
	    move IntRepMember_skel.cpp $(TDIR)

IntRep.cpp $(HDIR)\IntRep.h: $(IDLDIR)\IntRep.idl
	if exist $(IDL) \
	    del IntRep.cpp $(HDIR)\IntRep.h & \
	    del $(TDIR)\IntRep_skel.cpp $(HDIR)\IntRep_skel.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB \
	    --dll-import OB_IMPORT $(IDLDIR)\IntRep.idl & \
	    move IntRep.h $(HDIR) & \
	    move IntRep_skel.h $(HDIR) & \
	    move IntRep_skel.cpp $(TDIR)

ImplRep.cpp $(HDIR)\ImplRep.h: $(IDLDIR)\ImplRep.idl
	if exist $(IDL) \
	    del ImplRep.cpp $(HDIR)\ImplRep.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --no-skeletons --no-type-codes \
	    --dll-import OB_IMPORT $(IDLDIR)\ImplRep.idl & \
	    move ImplRep.h $(HDIR)

Dynamic.cpp $(HDIR)\Dynamic.h: $(IDLDIR)\Dynamic.idl
	if exist $(IDL) \
	    del Dynamic.cpp $(HDIR)\Dynamic.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --no-skeletons \
	    --dll-import OB_IMPORT $(IDLDIR)\Dynamic.idl & \
	    move Dynamic.h $(HDIR)

TCKind.cpp $(HDIR)\TCKind.h: $(IDLDIR)\TCKind.idl
	if exist $(IDL) \
	    del TCKind.cpp $(HDIR)\TCKind.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --no-skeletons --no-type-codes \
	    --dll-import OB_IMPORT $(IDLDIR)\TCKind.idl & \
	    move TCKind.h $(HDIR)

IOP.cpp $(HDIR)\IOP.h: $(IDLDIR)\IOP.idl
	if exist $(IDL) \
	    del IOP.cpp $(HDIR)\IOP.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --no-skeletons --no-type-codes \
	    --dll-import OB_IMPORT $(IDLDIR)\IOP.idl & \
	    move IOP.h $(HDIR)

GIOP.cpp $(HDIR)\GIOP.h: $(IDLDIR)\GIOP.idl
	if exist $(IDL) \
	    del GIOP.cpp $(HDIR)\GIOP.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --no-skeletons --no-type-codes \
	    --dll-import OB_IMPORT $(IDLDIR)\GIOP.idl & \
	    move GIOP.h $(HDIR)

IIOP.cpp $(HDIR)\IIOP.h: $(IDLDIR)\IIOP.idl
	if exist $(IDL) \
	    del IIOP.cpp $(HDIR)\IIOP.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --no-skeletons --no-type-codes \
	    --dll-import OB_IMPORT $(IDLDIR)\IIOP.idl & \
	    move IIOP.h $(HDIR)

DynAny.cpp $(HDIR)\DynAny.h: $(IDLDIR)\DynAny.idl
	if exist $(IDL) \
	    del DynAny.cpp $(HDIR)\DynAny.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --locality-constrained \
	    --dll-import OB_IMPORT $(IDLDIR)\DynAny.idl & \
	    move DynAny.h $(HDIR)

Current.cpp $(HDIR)\Current.h: $(IDLDIR)\Current.idl
	if exist $(IDL) \
	    del Current.cpp $(HDIR)\Current.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --locality-constrained \
	    --dll-import OB_IMPORT $(IDLDIR)\Current.idl & \
	    move Current.h $(HDIR)

Policy.cpp $(HDIR)\Policy.h: $(IDLDIR)\Policy.idl
	if exist $(IDL) \
	    del Policy.cpp $(HDIR)\Policy.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB --locality-constrained \
	    --dll-import OB_IMPORT $(IDLDIR)\Policy.idl & \
	    move Policy.h $(HDIR)

PolicyManager.cpp $(HDIR)\PolicyManager.h: $(IDLDIR)\PolicyManager.idl
	if exist $(IDL) \
	    del PolicyManager.cpp $(HDIR)\PolicyManager.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB \
	    --locality-constrained --no-virtual-inheritance \
	    --dll-import OB_IMPORT $(IDLDIR)\PolicyManager.idl & \
	    move PolicyManager.h $(HDIR)

OBPolicies.cpp $(HDIR)\OBPolicies.h: $(IDLDIR)\OBPolicies.idl
	if exist $(IDL) \
	    del OBPolicies.cpp $(HDIR)\OBPolicies.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB \
	    --locality-constrained --no-virtual-inheritance \
	    --dll-import OB_IMPORT $(IDLDIR)\OBPolicies.idl & \
	    move OBPolicies.h $(HDIR)

OCI.cpp $(HDIR)\OCI.h: $(IDLDIR)\OCI.idl
	if exist $(IDL) \
	    del OCI.cpp $(HDIR)\OCI.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB \
	    --locality-constrained --no-virtual-inheritance \
	    --dll-import OB_IMPORT $(IDLDIR)\OCI.idl & \
	    move OCI.h $(HDIR)

OCI_IIOP.cpp $(HDIR)\OCI_IIOP.h: $(IDLDIR)\OCI_IIOP.idl
	if exist $(IDL) \
	    del OCI_IIOP.cpp $(HDIR)\OCI_IIOP.h & \
	    $(IDL) -I$(IDLDIR) --header-dir OB \
	    --locality-constrained --no-virtual-inheritance \
	    --dll-import OB_IMPORT $(IDLDIR)\OCI_IIOP.idl & \
	    move OCI_IIOP.h $(HDIR)

install:: all
	copy $(NAME) $(libdir)
        copy $(PDB_NAME) $(libdir)

!if "$(DLL)" == "yes"

install:: all
	copy $(DLL_NAME) $(libdir)
	copy $(EXP_NAME) $(libdir)

!endif

clean::
	@del $(DLL_NAME) $(EXP_NAME) $(DEF_NAME)

!include .windep
