// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/Basic.h>
#include <OB/Template.h>
#include <OB/TemplateI.h>
#include <OB/Declarations.h>
#include <OB/Any.h>
#include <OB/NamedValue.h>

// ----------------------------------------------------------------------
// External, non-inline duplicate/release for templates
// ----------------------------------------------------------------------

void
OBDuplicate(CORBA_NamedValue_ptr p)
{
    if(p)
	p -> _OB_incRef();
}

void
OBRelease(CORBA_NamedValue_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

void
OBDuplicate(CORBA_NVList_ptr p)
{
    if(p)
	p -> _OB_incRef();
}

void
OBRelease(CORBA_NVList_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

// ----------------------------------------------------------------------
// Template instantiations
// ----------------------------------------------------------------------

#ifndef HAVE_NO_EXPLICIT_TEMPLATES
template class OBObjVar< CORBA_NamedValue >;
template class OBObjForSeq< CORBA_NamedValue >;
template class OBObjSeq< CORBA_NamedValue >;
template class OBSeqVar< OBObjSeq< CORBA_NamedValue > >;

template class OBObjVar< CORBA_NVList >;
template class OBObjForSeq< CORBA_NVList >;
//template class OBObjSeq< CORBA_NVList >;
//template class OBSeqVar< OBObjSeq< CORBA_NVList > >;
#else
#ifdef HAVE_PRAGMA_DEFINE
#pragma define(OBObjVar< CORBA_NamedValue >)
#pragma define(OBObjForSeq< CORBA_NamedValue >)
#pragma define(OBObjSeq< CORBA_NamedValue >)
#pragma define(OBSeqVar< OBObjSeq< CORBA_NamedValue > >)

#pragma define(OBObjVar< CORBA_NVList >)
#pragma define(OBObjForSeq< CORBA_NVList >)
//#pragma define(OBObjSeq< CORBA_NVList >)
//#pragma define(OBSeqVar< OBObjSeq< CORBA_NVList > >)
#endif
#endif

// ----------------------------------------------------------------------
// NamedValue constructor and destructor
// ----------------------------------------------------------------------

CORBA_NamedValue::CORBA_NamedValue()
    :  name_(CORBA_string_dup("")), value_(new CORBA_Any), flags_(0)
{
}

CORBA_NamedValue::CORBA_NamedValue(char* n, CORBA_Any* a, CORBA_Flags f)
    :  name_(n), value_(a), flags_(f)
{
}

// ----------------------------------------------------------------------
// NamedValue public member implementation
// ----------------------------------------------------------------------

const char*
CORBA_NamedValue::name() const
{
    return name_;
}

CORBA_Any*
CORBA_NamedValue::value() const
{
#ifdef HAVE_NO_MUTABLE
    return ((CORBA_NamedValue*)this) -> value_;
#else
    return value_;
#endif
}

CORBA_Flags
CORBA_NamedValue::flags() const
{
    return flags_;
}

// ----------------------------------------------------------------------
// NVList constructor
// ----------------------------------------------------------------------

CORBA_NVList::CORBA_NVList(CORBA_ULong n)
    : namedValueSeq_(n)
{
    //
    // The parameter n is only a "hint" for how many elements the user
    // intends to create with operations such as add_item(). Thus the
    // following code is disabled:
    //
//      namedValueSeq_.length(n);
//      for(CORBA_ULong i = 0 ; i < n ; i++)
//  	namedValueSeq_[i] = new CORBA_NamedValue;
}

// ----------------------------------------------------------------------
// NVList public member implementation
// ----------------------------------------------------------------------

CORBA_ULong
CORBA_NVList::count() const
{
    return namedValueSeq_.length();
}

CORBA_NamedValue_ptr
CORBA_NVList::add(CORBA_Flags f)
{
    CORBA_NamedValue_ptr p =
	new CORBA_NamedValue(CORBA_string_dup(""), new CORBA_Any, f);
    namedValueSeq_.append(p);
    return p;
}

CORBA_NamedValue_ptr
CORBA_NVList::add_item(const char* n, CORBA_Flags f)
{
    assert_nca(n, OBNCANullString);
    CORBA_NamedValue_ptr p = new CORBA_NamedValue(CORBA_string_dup(n),
						  new CORBA_Any, f);
    namedValueSeq_.append(p);
    return p;
}

CORBA_NamedValue_ptr
CORBA_NVList::add_value(const char* n, const CORBA_Any& a, CORBA_Flags f)
{
    assert_nca(n, OBNCANullString);
    CORBA_NamedValue_ptr p = new CORBA_NamedValue(CORBA_string_dup(n),
						  new CORBA_Any(a), f);
    namedValueSeq_.append(p);
    return p;
}

CORBA_NamedValue_ptr
CORBA_NVList::add_item_consume(char* n, CORBA_Flags f)
{
    assert_nca(n, OBNCANullString);
    CORBA_NamedValue_ptr p = new CORBA_NamedValue(n, new CORBA_Any, f);
    namedValueSeq_.append(p);
    return p;
}

CORBA_NamedValue_ptr
CORBA_NVList::add_value_consume(char* n, CORBA_Any* a, CORBA_Flags f)
{
    assert_nca(n, OBNCANullString);
    CORBA_NamedValue_ptr p = new CORBA_NamedValue(n, a, f);
    namedValueSeq_.append(p);
    return p;
}

CORBA_NamedValue_ptr
CORBA_NVList::item(CORBA_ULong n)
{
    return namedValueSeq_[n];
}

CORBA_Status
CORBA_NVList::remove(CORBA_ULong n)
{
    namedValueSeq_.remove(n);
}
