// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OCI_IMPL_H
#define OCI_IMPL_H

//
// The OCI_ConFactoryRegistry_impl class
//
class OCI_ConFactoryRegistry_impl : virtual public OCI_ConFactoryRegistry
{
    //
    // All transport factories
    //
    OCI_ConFactorySeq factories_;

    //
    // Hide copy-constructor and asignment operator
    //
    OCI_ConFactoryRegistry_impl(const OCI_ConFactoryRegistry_impl&);
    void operator=(const OCI_ConFactoryRegistry_impl&);

    OCI_ConFactoryRegistry_impl() { }
    virtual ~OCI_ConFactoryRegistry_impl() { }
    friend class CORBA_ORB; // ORBs may create OCI_ConFactoryRegistries_impls

public:

    //
    // Standard IDL to C++ Mapping
    //
    virtual void add_factory(OCI_ConFactory_ptr);
    virtual OCI_ConFactory_ptr get_factory(const OCI_IOR&);
    virtual OCI_ConFactory_ptr get_factory_with_policies(const OCI_IOR&,
							 const
							 CORBA_PolicyList&);
    virtual OCI_ConFactorySeq* get_factories();
    virtual CORBA_Boolean equivalent(const OCI_IOR&, const OCI_IOR&);
    virtual CORBA_ULong hash(const OCI_IOR&, CORBA_ULong maximum);
};

//
// The OCI_AccRegistry_impl class
//
class OCI_AccRegistry_impl : virtual public OCI_AccRegistry
{
    OCI_AcceptorSeq acceptors_; // All profile acceptors

    //
    // Hide copy-constructor and asignment operator
    //
    OCI_AccRegistry_impl(const OCI_AccRegistry_impl&);
    void operator=(const OCI_AccRegistry_impl&);

    OCI_AccRegistry_impl() { }
    virtual ~OCI_AccRegistry_impl() { }
    friend class CORBA_BOA; // BOAs may create OCI_AccRegistries_impls

public:

    //
    // Standard IDL to C++ Mapping
    //
    virtual void add_acceptor(OCI_Acceptor_ptr);
    virtual OCI_AcceptorSeq* get_acceptors();
    virtual void add_profiles(const OCI_ObjectKey&, OCI_IOR&);
    virtual OCI_ObjectKey* is_local(const OCI_IOR&);
};

//
// The OCI_Current_impl class
//
class OCI_Current_impl : virtual public OCI_Current
{
    //
    // Hide copy-constructor and asignment operator
    //
    OCI_Current_impl(const OCI_Current_impl&);
    void operator=(const OCI_Current_impl&);

    //
    // The timer list singleton
    //
    static OCI_Current_impl* instance_;
    friend class OBOCICurrentImplDestroyer;

#ifdef HAVE_JTC
    JTCThreadKey key_;
#else
    OCI_TransportInfo_var info_;
#endif

public:

    OCI_Current_impl();
    virtual ~OCI_Current_impl();
    
    //
    // Standard IDL to C++ Mapping
    //
    virtual OCI_TransportInfo_ptr get_oci_transport_info();
    virtual OCI_AcceptorInfo_ptr get_oci_acceptor_info();
    
    //
    // ORBacus internal functions
    // Application programs must not use these functions directly
    //
    static OCI_Current_impl* _OB_impl();
    static OCI_Current_ptr _OB_instance();
    OCI_TransportInfo_ptr _OB_setOCITransportInfo(OCI_TransportInfo_ptr);
};

#endif
