// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef GEN_RTF_H
#define GEN_RTF_H

//
// The RTF code generator class
//
class IdlRTFGenerator
{
    //
    // Special RTF "Pretty-Print" class
    //
    class PrettyPrint : public IdlPrettyPrint
    {
	CORBA_String_var path_;
	ofstream out_;

    public:

	PrettyPrint(const char*, const char*, const char*, const char*,
		    const char*, const char*, const char*, unsigned int = 4);
	virtual ~PrettyPrint();

	const char* path() const { return path_; }
	int good() { return out_.good(); }
	virtual void nl();
	virtual void start();
	virtual void end();
	virtual void printString(const char*);
    };

    //
    // RTF style constants
    //
    static const char* boldon_;  // <b>
    static const char* boldoff_; // </b>

    //
    // The keywords
    //
    static const char* keyException_;
    static const char* keyMember_;
    static const char* keyParam_;
    static const char* keyReturn_;
    static const char* keySee_;
    static const char* keySince_;
    static const char* keyAuthor_;
    static const char* keyVersion_;

    //
    // The top-level file name (without ".rtf")
    //
    static const char* top_;

    //
    // The program name
    //
    const char* prog_;

    //
    // The repository
    //
    CORBA_Repository_var repository_;

    //
    // Comments from IDL file
    //
    IdlCommentSeq commentSeq_;

    //
    // Keyword list
    //
    IdlStringSeq keywordSeq_;

    //
    // If true, don't sort symbols
    //
    bool noSort_;

    //
    // If true, ignore case when sorting
    //
    bool ignoreCase_;

    //
    // If true, create index
    //
    bool withIndex_;

    //
    // If set, write .rtf files to this path
    //
    const char* outDir_;

    //
    // If set, write .rtf code to this file
    //
    const char* singleFile_;

    //
    // Font names
    //
    const char* bodyFont_;
    const char* literalFont_;
    const char* titleFont_;
    const char* headingFont_;

    //
    // RTF font settings
    //
    CORBA_String_var body_;
    CORBA_String_var literal_;
    CORBA_String_var title_;
    CORBA_String_var heading_;

    //
    // Cache for absolute names
    //
    IdlStringSeq absSeq_;

    //
    // Cache for links
    //
    IdlStringSeq linkSeq_;

    //
    // Print comment
    //
    void comment(const char*, IdlPrettyPrint&);

    //
    // Print paragraph
    //
    void paragraph(const char*, IdlPrettyPrint&);

    //
    // Find and replace substrings, case insensitive
    //
    char* replace(const char*, const char*, const char*);

    //
    // Print intro
    //
    void intro(const char*, const char*, IdlPrettyPrint&);

    //
    // Create type string
    //
    enum GetType
    {
	GetTypeNormal,  // Normal type string
	GetTypeIn,      // Type string for use as in parameter
	GetTypeOut,     // Type string for use as out parameter
	GetTypeInOut    // Type string for use as inout parameter
    };
    
    char* getTypeString(const char*, CORBA_TypeCode_ptr,
			GetType = GetTypeNormal,
			const char* = 0);

    //
    // Get absolute name
    //
    char* getAbsolute(CORBA_Contained_ptr);
    char* getAbsolute(const char*);
   
    //
    // Fix absolute path name, i.e. replace "::" by "."
    //
    char* fixAbsolute(const char*);

    //
    // Get scope
    //
    void getScope(CORBA_Container_ptr, char*&);

    //
    // Print union labels
    //
    void printUnionLabels(const IdlUnionMemberInfo&, IdlPrettyPrint&,
			  CORBA_TypeCode_ptr);

    //
    // Generate code for the header file, general part
    //
    int genRTF(CORBA_Container_ptr, IdlPrettyPrint&);

    //
    // Tokenize
    //
    char *tokenize(char*);

    //
    // Check for keyword
    //
    bool isKeyword(const char*);

public:

    IdlRTFGenerator(const char*, CORBA_Repository_ptr,
		    const IdlCommentSeq&, const char*, const char*, bool, bool,
		    bool, const char*, const char*, const char*, const char*,
		    unsigned int, unsigned int, unsigned int, unsigned int);

    //
    // Generate RTF code
    //
    int gen();
};

#endif
