// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef GEN_UTIL_H
#define GEN_UTIL_H

//
// The "Pretty-Print" class
//
class IdlPrettyPrint
{
    ostream& out_;

    unsigned int _ob_num_;

protected:

    unsigned int indent_;
    unsigned int pos_;

    bool ignoreNextSep_;

    //
    // Newline with indent
    //
    virtual void nl();

public:

    IdlPrettyPrint(ostream& out, unsigned int num = 4)
	: out_(out), _ob_num_(num), indent_(0), pos_(0),
	  ignoreNextSep_(false) { }
    virtual ~IdlPrettyPrint() { }

    //
    // Set and get indent
    //
    void setIndent(unsigned int in) { indent_ = in; }
    unsigned int getIndent() const { return indent_; }

    //
    // Get and set output position
    //
    unsigned int getPos() const { return pos_; }
    void setPos(unsigned int pos) { pos_ = pos; };

    //
    // Print directly, without character interpretation
    //
    void direct(char c) { out_ << c; }
    void direct(const char* s) { out_ << s; }

    //
    // Increment and decrement indent
    //
    void inc() { indent_ += _ob_num_; }
    void dec() { assert(indent_ >= _ob_num_); indent_ -= _ob_num_; }

    //
    // Block start and end
    //
    virtual void start();
    virtual void end();

    //
    // Separator
    //
    virtual void sep();
    virtual void ignoreNextSep(bool);

    //
    // Print
    //
    virtual void printChar(char);
    virtual void printString(const char*);
};

//
// Output operators
//
IdlPrettyPrint& operator<<(IdlPrettyPrint&, char);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, const char*);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, short);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, int);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, long);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, unsigned short);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, unsigned int);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, unsigned long);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, float);
IdlPrettyPrint& operator<<(IdlPrettyPrint&, double);

//
// Remove scope from absolute name
//
void IdlRemoveScope(const char*, char*&);

//
// Get anonymous name from template name
//
char* IdlGetAnonName(const char*);

//
// Get original type, i.e. translate aliases to the real type
//
CORBA_IDLType_ptr IdlGetOrigIDLType(CORBA_IDLType_ptr);

//
// Check for variable size type
//
bool IdlIsVariable(CORBA_TypeCode_ptr);

//
// Get TypeCode converted to ASCII
// Output TypeCode converted to ASCII
//
char* IdlGetAsciiTypeCode(CORBA_TypeCode_ptr);
void IdlOutputAsciiTypeCode(CORBA_TypeCode_ptr, IdlPrettyPrint&);

//
// Convert path name to identifier
//
char* IdlPathToIdent(const char*);

//
// Check if union has an implicit default
//
bool IdlImplicitUnionDefault(CORBA_TypeCode_ptr);

//
// Get union info
//
IdlUnionMemberInfoSeq* IdlGetUnionInfo(CORBA_TypeCode_ptr);

//
// Create sequence with all base interfaces
//
void IdlGetAllBaseInterfaces(CORBA_InterfaceDef_ptr, CORBA_InterfaceDefSeq&);

//
// Get all method names
//
IdlStringSeq* IdlGetMethodNames(const CORBA_ContainedSeq&,
				const CORBA_ContainedSeq&);

//
// Check for C++ proprocessor
//
bool IdlCheckForCPP(const char*, const char*);

#endif
