// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef INT_REP_IMPL_H
#define INT_REP_IMPL_H

#include <OB/Narrow_impl.h>

#include <IntRepMember_impl.h>
#include <OB/IntRep_skel.h>

// ----------------------------------------------------------------------

class CORBA_Container_impl;
class CORBA_Contained_impl : public virtual CORBA_Contained_skel,
			     public virtual CORBA_IRObject_impl
{
protected:

    CORBA_Container_var definedIn_;
    CORBA_RepositoryId_var id_;
    CORBA_Identifier_var name_;
    CORBA_VersionSpec_var version_;

public:

    CORBA_Contained_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_Contained_impl();

    virtual void releaseInternal();

    virtual void destroy();

    virtual char* id();
    virtual void id(const char*);

    virtual char* name();
    virtual void name(const char*);

    virtual char* version();
    virtual void version(const char*);

    virtual CORBA_Container_ptr defined_in();
    virtual char* absolute_name();
    virtual CORBA_Repository_ptr containing_repository();

    virtual Description* describe() = 0;

    virtual void move(CORBA_Container_ptr new_container,
		      const char* identifier,
		      const char* new_version);

    OB_MAKE_NARROW_IMPL(CORBA_Contained_impl)
};

// ----------------------------------------------------------------------

class CORBA_Container_impl : public virtual CORBA_Container_skel,
			     public virtual CORBA_IRObject_impl
{
protected:

    CORBA_ContainedSeq contents_;

    friend class CORBA_Contained_impl;
    void add(CORBA_Contained_ptr);
    void remove(CORBA_Contained_ptr);

public:

    CORBA_Container_impl(CORBA_ORB_ptr);
    virtual ~CORBA_Container_impl();

    virtual void releaseInternal();

    virtual CORBA_Contained_ptr lookup(const char* search_name);
    
    virtual CORBA_ContainedSeq* contents(CORBA_DefinitionKind limit_type,
					 CORBA_Boolean exclude_inherited);
    
    virtual CORBA_ContainedSeq* lookup_name(const char* search_name,
					    CORBA_Long levels_to_search,
					    CORBA_DefinitionKind limit_type,
					    CORBA_Boolean exclude_inherited);
    
    virtual DescriptionSeq*
    describe_contents(CORBA_DefinitionKind limit_type,
		      CORBA_Boolean exclude_inherited,
		      CORBA_Long max_returned_objs);
    
    virtual CORBA_ModuleDef_ptr
    create_module(const char* id,
		  const char* name,
		  const char* version);
    
    virtual CORBA_ConstantDef_ptr
    create_constant(const char* id,
		    const char* name,
		    const char* version,
		    CORBA_IDLType_ptr type,
		    const CORBA_Any& value);
    
    virtual CORBA_StructDef_ptr
    create_struct(const char* id,
		  const char* name,
		  const char* version,
		  const CORBA_StructMemberSeq& members);
    
    virtual CORBA_UnionDef_ptr
    create_union(const char* id,
		 const char* name,
		 const char* version,
		 CORBA_IDLType_ptr discriminator_type,
		 const CORBA_UnionMemberSeq& members);
    
    virtual CORBA_EnumDef_ptr
    create_enum(const char* id,
		const char* name,
		const char* version,
		const CORBA_EnumMemberSeq& members);
    
    virtual CORBA_AliasDef_ptr
    create_alias(const char* id,
		 const char* name,
		 const char* version,
		 CORBA_IDLType_ptr original_type);
    
    virtual CORBA_InterfaceDef_ptr
    create_interface(const char* id,
		     const char* name,
		     const char* version,
		     const CORBA_InterfaceDefSeq& base_interfaces);
    
    virtual CORBA_ExceptionDef_ptr
    create_exception(const char* id,
		     const char* name,
		     const char* version,
		     const CORBA_StructMemberSeq& members);
    
    OB_MAKE_NARROW_IMPL(CORBA_Container_impl)
};

// ----------------------------------------------------------------------

class CORBA_ModuleDef_impl : public virtual CORBA_ModuleDef_skel,
			     public virtual CORBA_Container_impl,
			     public virtual CORBA_Contained_impl
{
public:
    
    CORBA_ModuleDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_ModuleDef_impl();
    
    virtual void releaseInternal();
    
    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Module; }

    virtual CORBA_Contained::Description* describe();

    OB_MAKE_NARROW_IMPL(CORBA_ModuleDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_ConstantDef_impl : public virtual CORBA_ConstantDef_skel,
			       public virtual CORBA_Contained_impl
{
    CORBA_IDLType_var idlType_;
    CORBA_Any value_;

public:

    CORBA_ConstantDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_ConstantDef_impl();
    
    virtual void releaseInternal();
    
    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Constant; }
    
    virtual Description* describe();
    
    virtual CORBA_TypeCode_ptr type();
    
    virtual CORBA_IDLType_ptr type_def();
    virtual void type_def(CORBA_IDLType_ptr);

    virtual CORBA_Any* value();
    virtual void value(const CORBA_Any&);
    
    OB_MAKE_NARROW_IMPL(CORBA_ConstantDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_TypedefDef_impl : public virtual CORBA_TypedefDef_skel,
			      public virtual CORBA_Contained_impl,
			      public virtual CORBA_IDLType_impl
{
public:

    CORBA_TypedefDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_TypedefDef_impl();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Typedef; }

    virtual Description* describe();

    OB_MAKE_NARROW_IMPL(CORBA_TypedefDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_StructDef_impl : public virtual CORBA_StructDef_skel,
			     public virtual CORBA_TypedefDef_impl
{
    CORBA_StructMemberSeq members_;
    
public:
    
    CORBA_StructDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_StructDef_impl();
    
    virtual void releaseInternal();
    
    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Struct; }
    
    virtual CORBA_TypeCode_ptr type();
    
    virtual CORBA_StructMemberSeq* members();
    virtual void members(const CORBA_StructMemberSeq&);
    
    OB_MAKE_NARROW_IMPL(CORBA_StructDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_UnionDef_impl : public virtual CORBA_UnionDef_skel,
			    public virtual CORBA_TypedefDef_impl
{
    CORBA_IDLType_var discType_;
    CORBA_UnionMemberSeq members_;
    
public:
    
    CORBA_UnionDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_UnionDef_impl();
    
    virtual void releaseInternal();
    
    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Union; }

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_TypeCode_ptr discriminator_type();

    virtual CORBA_IDLType_ptr discriminator_type_def();
    virtual void discriminator_type_def(CORBA_IDLType_ptr);

    virtual CORBA_UnionMemberSeq* members();
    virtual void members(const CORBA_UnionMemberSeq&);

    OB_MAKE_NARROW_IMPL(CORBA_UnionDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_EnumDef_impl : public virtual CORBA_EnumDef_skel,
			   public virtual CORBA_TypedefDef_impl
{
    CORBA_EnumMemberSeq members_;

public:

    CORBA_EnumDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_EnumDef_impl();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Enum; }

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_EnumMemberSeq* members();
    virtual void members(const CORBA_EnumMemberSeq&);

    OB_MAKE_NARROW_IMPL(CORBA_EnumDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_AliasDef_impl : public virtual CORBA_AliasDef_skel,
			    public virtual CORBA_TypedefDef_impl
{
    CORBA_IDLType_var idlType_;

public:

    CORBA_AliasDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_AliasDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Alias; }

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_IDLType_ptr original_type_def();
    virtual void original_type_def(CORBA_IDLType_ptr);

    OB_MAKE_NARROW_IMPL(CORBA_AliasDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_PrimitiveDef_impl : public virtual CORBA_PrimitiveDef_skel,
				public virtual CORBA_IDLType_impl
{
    CORBA_PrimitiveKind primitiveKind;

public:

    CORBA_PrimitiveDef_impl(CORBA_ORB_ptr, CORBA_PrimitiveKind);
    virtual ~CORBA_PrimitiveDef_impl();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Primitive; }

    virtual void destroy();

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_PrimitiveKind kind();

    OB_MAKE_NARROW_IMPL(CORBA_PrimitiveDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_StringDef_impl : public virtual CORBA_StringDef_skel,
			     public virtual CORBA_IDLType_impl
{
    CORBA_Repository_var repository_;

    CORBA_ULong bound_;

public:

    CORBA_StringDef_impl(CORBA_ORB_ptr, CORBA_Repository_ptr);
    virtual ~CORBA_StringDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_String; }

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_ULong bound();
    virtual void bound(CORBA_ULong);

    OB_MAKE_NARROW_IMPL(CORBA_StringDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_SequenceDef_impl : public virtual CORBA_SequenceDef_skel,
			       public virtual CORBA_IDLType_impl
{
    CORBA_Repository_var repository_;

    CORBA_ULong bound_;
    CORBA_IDLType_var elementType_;

public:

    CORBA_SequenceDef_impl(CORBA_ORB_ptr, CORBA_Repository_ptr);
    virtual ~CORBA_SequenceDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Sequence; }

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_ULong bound();
    virtual void bound(CORBA_ULong);

    virtual CORBA_TypeCode_ptr element_type();

    virtual CORBA_IDLType_ptr element_type_def();
    virtual void element_type_def(CORBA_IDLType_ptr);

    OB_MAKE_NARROW_IMPL(CORBA_SequenceDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_ArrayDef_impl : public virtual CORBA_ArrayDef_skel,
			    public virtual CORBA_IDLType_impl
{
    CORBA_Repository_var repository_;

    CORBA_ULong length_;
    CORBA_IDLType_var elementType_;

public:

    CORBA_ArrayDef_impl(CORBA_ORB_ptr, CORBA_Repository_ptr);
    virtual ~CORBA_ArrayDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Array; }

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_ULong length();
    virtual void length(CORBA_ULong);

    virtual CORBA_TypeCode_ptr element_type();

    virtual CORBA_IDLType_ptr element_type_def();
    virtual void element_type_def(CORBA_IDLType_ptr);

    OB_MAKE_NARROW_IMPL(CORBA_ArrayDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_ExceptionDef_impl : public virtual CORBA_ExceptionDef_skel,
				public virtual CORBA_Contained_impl
{
    CORBA_StructMemberSeq members_;

public:

    CORBA_ExceptionDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_ExceptionDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Exception; }

    virtual CORBA_Contained::Description* describe();

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_StructMemberSeq* members();
    virtual void members(const CORBA_StructMemberSeq&);

    OB_MAKE_NARROW_IMPL(CORBA_ExceptionDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_AttributeDef_impl : public virtual CORBA_AttributeDef_skel,
				public virtual CORBA_Contained_impl
{
    CORBA_IDLType_var idlType_;
    CORBA_AttributeMode attributeMode_;

public:

    CORBA_AttributeDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_AttributeDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Attribute; }

    virtual char* name() { return CORBA_Contained_impl::name(); }
    virtual void name(const char*);

    virtual CORBA_Contained::Description* describe();

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_IDLType_ptr type_def();
    virtual void type_def(CORBA_IDLType_ptr);

    virtual CORBA_AttributeMode mode();
    virtual void mode(CORBA_AttributeMode);

    OB_MAKE_NARROW_IMPL(CORBA_AttributeDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_OperationDef_impl : public virtual CORBA_OperationDef_skel,
				public virtual CORBA_Contained_impl
{
    CORBA_IDLType_var result_;
    CORBA_OperationMode mode_;
    CORBA_ParDescriptionSeq params_;
    CORBA_ExceptionDefSeq exceptions_;
    CORBA_ContextIdSeq contexts_;

public:

    CORBA_OperationDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_OperationDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Operation; }

    virtual char* name() { return CORBA_Contained_impl::name(); }
    virtual void name(const char*);

    virtual CORBA_Contained::Description* describe();

    virtual CORBA_TypeCode_ptr result();

    virtual CORBA_IDLType_ptr result_def();
    virtual void result_def(CORBA_IDLType_ptr);

    virtual CORBA_ParDescriptionSeq* params();
    virtual void params(const CORBA_ParDescriptionSeq&);

    virtual CORBA_OperationMode mode();
    virtual void mode(CORBA_OperationMode);

    virtual CORBA_ContextIdSeq* contexts();
    virtual void contexts(const CORBA_ContextIdSeq&);

    virtual CORBA_ExceptionDefSeq* exceptions();
    virtual void exceptions(const CORBA_ExceptionDefSeq&);

    OB_MAKE_NARROW_IMPL(CORBA_OperationDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_InterfaceDef_impl : public virtual CORBA_InterfaceDef_skel,
				public virtual CORBA_Container_impl,
				public virtual CORBA_Contained_impl,
				public virtual CORBA_IDLType_impl
{
    CORBA_InterfaceDefSeq baseInterfaces_;

public:

    CORBA_InterfaceDef_impl(CORBA_ORB_ptr, CORBA_Container_ptr);
    virtual ~CORBA_InterfaceDef_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Interface; }

    virtual CORBA_TypeCode_ptr type();

    virtual CORBA_Contained::Description* describe();

    virtual CORBA_Contained_ptr lookup(const char* search_name);

    virtual CORBA_ContainedSeq* contents(CORBA_DefinitionKind limit_type,
					 CORBA_Boolean exclude_inherited);

    virtual CORBA_ContainedSeq* lookup_name(const char* search_name,
					    CORBA_Long levels_to_search,
					    CORBA_DefinitionKind limit_type,
					    CORBA_Boolean exclude_inherited);

    virtual CORBA_InterfaceDefSeq* base_interfaces();
    virtual void base_interfaces(const CORBA_InterfaceDefSeq&);

    virtual CORBA_Boolean is_a(const char* interface_id);

    virtual FullInterfaceDescription* describe_interface();

    virtual CORBA_AttributeDef_ptr
    create_attribute(const char* id,
		     const char* name,
		     const char* version,
		     CORBA_IDLType_ptr type,
		     CORBA_AttributeMode mode);

    virtual CORBA_OperationDef_ptr
    create_operation(const char* id,
		     const char* name,
		     const char* version,
		     CORBA_IDLType_ptr result,
		     CORBA_OperationMode mode,
		     const CORBA_ParDescriptionSeq& params,
		     const CORBA_ExceptionDefSeq& exceptions,
		     const CORBA_ContextIdSeq& contexts);

    OB_MAKE_NARROW_IMPL(CORBA_InterfaceDef_impl)
};

// ----------------------------------------------------------------------

class CORBA_Repository_impl : public virtual CORBA_Repository_skel,
			      public virtual CORBA_Container_impl
{
    CORBA_Contained_ptr lookup_id_in_seq(const CORBA_ContainedSeq&,
					 const char*);

protected:

    CORBA_PrimitiveDef_var primDefNull;
    CORBA_PrimitiveDef_var primDefVoid;
    CORBA_PrimitiveDef_var primDefShort;
    CORBA_PrimitiveDef_var primDefLong;
    CORBA_PrimitiveDef_var primDefUShort;
    CORBA_PrimitiveDef_var primDefULong;
    CORBA_PrimitiveDef_var primDefFloat;
    CORBA_PrimitiveDef_var primDefDouble;
    CORBA_PrimitiveDef_var primDefBoolean;
    CORBA_PrimitiveDef_var primDefChar;
    CORBA_PrimitiveDef_var primDefOctet;
    CORBA_PrimitiveDef_var primDefAny;
    CORBA_PrimitiveDef_var primDefTypeCode;
    CORBA_PrimitiveDef_var primDefPrincipal;
    CORBA_PrimitiveDef_var primDefString;
    CORBA_PrimitiveDef_var primDefObjref;

    IdlStringDefSeq strings_;
    IdlSequenceDefSeq sequences_;
    IdlArrayDefSeq arrays_;

public:

    CORBA_Repository_impl(CORBA_ORB_ptr);
    virtual ~CORBA_Repository_impl();

    virtual void releaseInternal();

    virtual CORBA_DefinitionKind def_kind() { return CORBA_dk_Repository; }

    virtual void destroy();

    virtual CORBA_Contained_ptr lookup(const char* search_name);

    virtual CORBA_Contained_ptr lookup_id(const char* search_id);

    CORBA_PrimitiveDef_ptr get_primitive(CORBA_PrimitiveKind kind);

    CORBA_StringDef_ptr
    create_string(CORBA_ULong bound);
    
    CORBA_SequenceDef_ptr
    create_sequence(CORBA_ULong bound,
		    CORBA_IDLType_ptr element_type);
    
    CORBA_ArrayDef_ptr
    create_array(CORBA_ULong length,
		 CORBA_IDLType_ptr element_type);
    
    
    OB_MAKE_NARROW_IMPL(CORBA_Repository_impl)
};

// ----------------------------------------------------------------------

#endif
