# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..\..

LIB_NAME	= $(top_srcdir)\lib\idl.lib

IDL_NAME	= $(top_srcdir)\bin\idl.exe
SERV_NAME	= $(top_srcdir)\bin\irserv.exe
FEED_NAME	= $(top_srcdir)\bin\irfeed.exe
DEL_NAME	= $(top_srcdir)\bin\irdel.exe
GEN_NAME	= $(top_srcdir)\bin\irgen.exe
JIDL_NAME	= $(top_srcdir)\bin\jidl.exe
HIDL_NAME	= $(top_srcdir)\bin\hidl.exe
RIDL_NAME	= $(top_srcdir)\bin\ridl.exe

LIB_PDB_NAME    = $(top_srcdir)\lib\idl.pdb

UTILS =           $(IDL_NAME) \
		  $(SERV_NAME) \
		  $(FEED_NAME) \
		  $(DEL_NAME) \
		  $(GEN_NAME) \
		  $(JIDL_NAME) \
		  $(HIDL_NAME) \
		  $(RIDL_NAME)
#
# Work around the inference rules problem with nmake.
#
!ifndef BUILD_UTILS

PDB_FLAGS       = /Fd$(LIB_PDB_NAME)
TARGETS		= $(LIB_NAME)

!else

TARGETS 	= $(UTILS)

!endif

!include $(top_srcdir)\config\Make.rules.mak

IDLDIR		= $(top_srcdir)\idl

SUBDIRS		= cpp

LIB_OBJS	= Util.obj \
		  Types.obj \
		  Gram.obj \
		  GramUtil.obj \
		  Scan.obj \
		  IntRepMember_skel.obj \
		  IntRep_skel.obj \
		  IntRepMember_impl.obj \
		  IntRep_impl.obj \
		  GenCPP.obj \
		  GenCPPH.obj \
		  GenCPPC.obj \
		  GenCPPSkelH.obj \
		  GenCPPSkelC.obj \
		  GenCPPTieH.obj \
		  GenCPPUtil.obj \
		  GenUtil.obj \
		  GenJava.obj \
		  GenJavaUtil.obj \
		  GenHTML.obj \
		  GenHTMLUtil.obj \
		  GenRTF.obj \
		  GenRTFUtil.obj

IDL_OBJS	= IDL.obj
SERV_OBJS	= Server.obj
FEED_OBJS	= Feed.obj
DEL_OBJS	= Del.obj
GEN_OBJS	= Gen.obj
JIDL_OBJS	= JIDL.obj
HIDL_OBJS	= HIDL.obj
RIDL_OBJS	= RIDL.obj

ALL_CXXFLAGS	= $(CXXFLAGS) $(PDB_FLAGS)

ALL_CPPFLAGS	= /I. /Iwininclude $(OB_CPPFLAGS) $(CPPFLAGS) 
ALL_LIBS	= $(LIB_NAME) $(OB_LIBS) $(LIBS)

$(LIB_NAME): $(LIB_OBJS)
	$(AR) $(ARFLAGS) /out:$@ $(LIB_OBJS)
    
$(SERV_NAME): $(SERV_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(SERV_OBJS) $(ALL_LIBS) setargv.obj

$(FEED_NAME): $(FEED_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(FEED_OBJS) $(ALL_LIBS) setargv.obj

$(DEL_NAME): $(DEL_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(DEL_OBJS) $(ALL_LIBS) setargv.obj

$(GEN_NAME): $(GEN_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(GEN_OBJS) $(ALL_LIBS) setargv.obj

$(IDL_NAME): $(IDL_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(IDL_OBJS) $(ALL_LIBS) setargv.obj

$(JIDL_NAME): $(JIDL_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(JIDL_OBJS) $(ALL_LIBS) setargv.obj

$(HIDL_NAME): $(HIDL_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(HIDL_OBJS) $(ALL_LIBS) setargv.obj

$(RIDL_NAME): $(RIDL_OBJS)  $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ $(RIDL_OBJS) $(ALL_LIBS) setargv.obj

Types.cpp Types.h: Types.idl
	if exist $(IDL) \
	    del Types.cpp Types.h & \
	    $(IDL) -I$(IDLDIR) --other-header-dir OB \
	    --no-skeletons --no-type-codes Types.idl

!ifndef BUILD_UTILS

install:: all

all depend install clean test::
        $(MAKE) /f Makefile.mak BUILD_UTILS=1 $@

!else

install:: all
	copy $(LIB_NAME) $(libdir)
	copy $(LIB_PDB_NAME) $(libdir)
	copy $(IDL_NAME) $(bindir)
	copy $(JIDL_NAME) $(bindir)
	copy $(HIDL_NAME) $(bindir)
	copy $(RIDL_NAME) $(bindir)
	copy $(SERV_NAME) $(bindir)
	copy $(FEED_NAME) $(bindir)
	copy $(DEL_NAME) $(bindir)
	copy $(GEN_NAME) $(bindir)

all depend install clean test::
	@for %i in ( $(SUBDIRS) ) do \
	    @cmd /c "cd %i & $(MAKE) /f Makefile.mak $@"

!endif

!include .windep
