// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>

#include <stdlib.h>

#ifdef TEST_X11_REACTOR
#   include <X11/Intrinsic.h>
#   include <OB/X11.h>
#endif

int
main(int argc, char* argv[], char*[])
{
    int status;

    try
    {
#ifdef TEST_X11_REACTOR
	XtAppContext appContext;
	Widget topLevel = XtAppInitialize(&appContext, "Test", 0, 0,
					  &argc, argv, 0, 0, 0);
	OBX11Init(appContext);
#endif

        //
        // Create ORB
        //
        CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);

	//
	// Run tests
	//
	int ClientRun(CORBA_ORB_ptr, int, char*[]);
	status = ClientRun(orb, argc, argv);
    }
    catch(CORBA_SystemException& ex)
    {
	OBPrintException(ex);
	status = 1;
    }

    return status;
}
