// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
#include <stdio.h>

#include <OB/CORBA.h>
#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

#include <string.h>

void
TestConst()
{
    {
	const CORBA_Long constLong = -1234;
	TEST(constLong == ConstLong);
	
	const CORBA_ULong constULong = (5432 + constLong ) * 100 % 124;
	TEST(constULong == ConstULong);
	
	const CORBA_Double constDouble = 50.23 - constLong *
	    (constULong - 3.14);
	TEST(constDouble == ConstDouble);
	
	const CORBA_Float constFloat = (CORBA_Float)(constDouble * 1.11);
//
// Visual C++ fails on this test. If I put a print statement for constFloat
// and ConstFloat, the test succeeds. So I assume this is a Visual C++ bug.
//
#ifndef HAVE_VCPLUSPLUS_BUGS
	TEST(constFloat == ConstFloat);
#endif
	
	const CORBA_Short constShort = -23 % 10;
	TEST(constShort == ConstShort);
	
	const CORBA_Boolean constBoolean = true;
	TEST(constBoolean == ConstBoolean);
	
	const char* constString = "This is ConstString";
	TEST(strcmp(constString, ConstString) == 0);
    }

    {
	const CORBA_Long constLong = (0xf | 0xf000) & 0xfffe;
	TEST(constLong == TestConstInterface::ConstLong);
	
	const CORBA_Char constChar1 = (CORBA_Char)'c';
	TEST(constChar1 == TestConstInterface::ConstChar1);
	
	const CORBA_Char constChar2 = (CORBA_Char)'\n';
	TEST(constChar2 == TestConstInterface::ConstChar2);
	
	const CORBA_Char constChar3 = (CORBA_Char)'\377';
	TEST(constChar3 == TestConstInterface::ConstChar3);
	
	const CORBA_Char constChar4 = (CORBA_Char)'\x88';
	TEST(constChar4 == TestConstInterface::ConstChar4);
	
	const CORBA_Char constChar5 = (CORBA_Char)'\'';
	TEST(constChar5 == TestConstInterface::ConstChar5);
	
	const char* constString = "\n\t\v\b\r\f\a\\\?\'\"\xff\377\7";
	TEST(strcmp(constString, TestConstInterface::ConstString) == 0);
    }
}
