// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

void
TestDIIContext(CORBA_Object_ptr ti, CORBA_ORB_ptr orb)
{
    CORBA_Context_var ctx;

    {
	orb -> get_default_context(ctx.out());

	CORBA_Request_var request;

	request = ti -> _request("opContext");
	request -> contexts() -> add("A*");
	request -> contexts() -> add("C*");
	request -> contexts() -> add("X");
	request -> contexts() -> add("Z");
	request -> ctx(ctx);
	request -> add_in_arg() <<= (const char*)"*";
	request -> set_return_type(TestInterface::_tc_StringSequence);
        try
        {
            request -> invoke();
            CORBA_Exception* ex = request -> env() -> exception();
            CORBA_BAD_CONTEXT* bex;
            TEST(bex = CORBA_BAD_CONTEXT::_narrow(ex));
            TEST(bex);
        }
        catch(const CORBA_BAD_CONTEXT&)
        {
            // Expected (if ooc.orb.raise_dii_exceptions = true)
        }
    }

    {
	orb -> get_default_context(ctx.out());

	CORBA_Any any;
	CORBA_ULong i;

	any <<= (const char*)"A1";
	ctx -> set_one_value("A", any);

	any <<= (const char*)"A2";
	ctx -> set_one_value("AAA", any);

	any <<= (const char*)"B1";
	ctx -> set_one_value("B", any);

	any <<= (const char*)"B2";
	ctx -> set_one_value("BBB", any);

	any <<= (const char*)"X1";
	ctx -> set_one_value("X", any);

	any <<= (const char*)"X2";
	ctx -> set_one_value("XXX", any);

	any <<= (const char*)"Y1";
	ctx -> set_one_value("Y", any);

	any <<= (const char*)"Y2";
	ctx -> set_one_value("YYY", any);

	CORBA_Request_var request;
	TestInterface::StringSequence* seq;

	request = ti -> _request("opContext");
	request -> contexts() -> add("A*");
	request -> contexts() -> add("C*");
	request -> contexts() -> add("X");
	request -> contexts() -> add("Z");
	request -> ctx(ctx);
	request -> set_return_type(TestInterface::_tc_StringSequence);
	request -> add_in_arg() <<= (const char*)"*";
	request -> invoke();
	TEST(request -> return_value() >>= seq);

	TEST(seq -> length() == 3 * 2);
	i = 0;
	TEST(strcmp((*seq)[i++], "A") == 0 &&
	     strcmp((*seq)[i++], "A1") == 0);
	TEST(strcmp((*seq)[i++], "AAA") == 0 &&
	     strcmp((*seq)[i++], "A2") == 0);
	TEST(strcmp((*seq)[i++], "X") == 0 &&
	     strcmp((*seq)[i++], "X1") == 0);

	request = ti -> _request("opContext");
	request -> contexts() -> add("A*");
	request -> contexts() -> add("C*");
	request -> contexts() -> add("X");
	request -> contexts() -> add("Z");
	request -> ctx(ctx);
	request -> set_return_type(TestInterface::_tc_StringSequence);
	request -> add_in_arg() <<= (const char*)"A*";
	request -> invoke();
	TEST(request -> return_value() >>= seq);

	TEST(seq -> length() == 2 * 2);
	i = 0;
	TEST(strcmp((*seq)[i++], "A") == 0 &&
	     strcmp((*seq)[i++], "A1") == 0);
	TEST(strcmp((*seq)[i++], "AAA") == 0 &&
	     strcmp((*seq)[i++], "A2") == 0);

	request = ti -> _request("opContext");
	request -> contexts() -> add("A*");
	request -> contexts() -> add("C*");
	request -> contexts() -> add("X");
	request -> contexts() -> add("Z");
	request -> ctx(ctx);
	request -> set_return_type(TestInterface::_tc_StringSequence);
	request -> add_in_arg() <<= (const char*)"AA*";
	request -> invoke();
	TEST(request -> return_value() >>= seq);

	TEST(seq -> length() == 1 * 2);
	i = 0;
	TEST(strcmp((*seq)[i++], "AAA") == 0 &&
	     strcmp((*seq)[i++], "A2") == 0);

	request = ti -> _request("opContext");
	request -> contexts() -> add("A*");
	request -> contexts() -> add("C*");
	request -> contexts() -> add("X");
	request -> contexts() -> add("Z");
	request -> ctx(ctx);
	request -> set_return_type(TestInterface::_tc_StringSequence);
	request -> add_in_arg() <<= (const char*)"A";
	request -> invoke();
	TEST(request -> return_value() >>= seq);

	TEST(seq -> length() == 1 * 2);
	i = 0;
	TEST(strcmp((*seq)[i++], "A") == 0 &&
	     strcmp((*seq)[i++], "A1") == 0);
    }
}
