// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

void
TestStub(TestInterface_ptr ti)
{
    CORBA_ULong i, j, k, l;

    {
	ti -> opVoid();
    }

    {
	CORBA_Short ret;
	ti -> attrShort(-32768);
	ret = ti -> attrShort();
	TEST(ret == -32768);

	ti -> attrShort(32767);
	ret = ti -> attrShort();
	TEST(ret == 32767);

	CORBA_Short inOut, out;
	inOut = 20;
	ret = ti -> opShort(10, inOut, out);
	TEST(ret == 30);
	TEST(inOut == 30);
	TEST(out == 30);
    }

    {
	CORBA_Long ret;
	ti -> attrLong(-2147483647 - 1);
	ret = ti -> attrLong();
	TEST(ret == -2147483647 - 1);

	ti -> attrLong(2147483647);
	ret = ti -> attrLong();
	TEST(ret == 2147483647);

	CORBA_Long inOut, out;
	inOut = 20;
	ret = ti -> opLong(10, inOut, out);
	TEST(ret == 30);
	TEST(inOut == 30);
	TEST(out == 30);
    }

    {
	CORBA_UShort ret;
	ti -> attrUShort(65535U);
	ret = ti -> attrUShort();
	TEST(ret == 65535U);

	CORBA_UShort inOut, out;
	inOut = 20;
	ret = ti -> opUShort(10, inOut, out);
	TEST(ret == 30);
	TEST(inOut == 30);
	TEST(out == 30);
    }

    {
	CORBA_ULong ret;
	ti -> attrULong(4294967295U);
	ret = ti -> attrULong();
	TEST(ret == 4294967295U);

	CORBA_ULong inOut, out;
	inOut = 20;
	ret = ti -> opULong(10, inOut, out);
	TEST(ret == 30);
	TEST(inOut == 30);
	TEST(out == 30);
    }

    {
	CORBA_Float ret;
	ti -> attrFloat(3.40282347E+38F);
	ret = ti -> attrFloat();
	TEST(ret == 3.40282347E+38F);

	ti -> attrFloat(1.17549435E-38F);
	ret = ti -> attrFloat();
	TEST(ret == 1.17549435E-38F);

	CORBA_Float inOut, out;
	inOut = 20;
	ret = ti -> opFloat(10, inOut, out);
	TEST(ret == 30);
	TEST(inOut == 30);
	TEST(out == 30);
    }

    {
	CORBA_Double ret;
	ti -> attrDouble(1.7976931348623157E+308);
	ret = ti -> attrDouble();
	TEST(ret == 1.7976931348623157E+308);

	ti -> attrDouble(2.2250738585072014E-308);
	ret = ti -> attrDouble();
#if !( defined(__alpha) && defined(__linux) )
 	TEST(ret == 2.2250738585072014E-308);
#endif

	CORBA_Double inOut, out;
	inOut = 20;
	ret = ti -> opDouble(10, inOut, out);
	TEST(ret == 30);
	TEST(inOut == 30);
	TEST(out == 30);
    }

    {
	CORBA_Boolean ret;
	ti -> attrBoolean(true);
	ret = ti -> attrBoolean();
	TEST(ret == CORBA_TRUE);

	ti -> attrBoolean(false);
	ret = ti -> attrBoolean();
	TEST(ret == CORBA_FALSE);

	CORBA_Boolean inOut, out;
	inOut = true;
	ret = ti -> opBoolean(true, inOut, out);
	TEST(ret == CORBA_TRUE);
	TEST(inOut == CORBA_TRUE);
	TEST(out == CORBA_TRUE);

	inOut = true;
	ret = ti -> opBoolean(false, inOut, out);
	TEST(ret == CORBA_FALSE);
	TEST(inOut == CORBA_FALSE);
	TEST(out == CORBA_FALSE);

	inOut = false;
	ret = ti -> opBoolean(true, inOut, out);
	TEST(ret == CORBA_FALSE);
	TEST(inOut == CORBA_FALSE);
	TEST(out == CORBA_FALSE);
    }

    {
	CORBA_Char ret;
	ti -> attrChar('a');
	ret = ti -> attrChar();
	TEST(ret == 'a');
	ti -> attrChar(224);
	ret = ti -> attrChar();
	TEST(ret == 224);

	CORBA_Char inOut, out;
	inOut = 1;
	ret = ti -> opChar('a', inOut, out);
	TEST(ret == 'b');
	TEST(inOut == 'b');
	TEST(out == 'b');
    }

    {
	CORBA_Octet ret;
	ti -> attrOctet(0xff);
	ret = ti -> attrOctet();
	TEST(ret == 0xff);

	ti -> attrOctet(0);
	ret = ti -> attrOctet();
	TEST(ret == 0);

	CORBA_Octet inOut, out;
	inOut = 20;
	ret = ti -> opOctet(10, inOut, out);
	TEST(ret == 30);
	TEST(inOut == 30);
	TEST(out == 30);
    }

    {
	CORBA_String_var ret;
	ti -> attrString("Hello");
	ret = ti -> attrString();
	TEST(strcmp(ret, "Hello") == 0);

	CORBA_String_var inOut, out;
	inOut = CORBA_string_dup("world!");
	ret = ti -> opString("Hello, ", inOut.inout(), out.out());
	TEST(strcmp(ret, "Hello, world!") == 0);
	TEST(strcmp(out, "Hello, world!") == 0);
    }

    {
	CORBA_Any any;
	CORBA_Any_var ret;

	any <<= (const char*)"abc";
	ti -> attrAny(any);
	ret = ti -> attrAny();
	char* s;
	TEST(ret >>= s);
	TEST(strcmp(s, "abc") == 0);

	any <<= (CORBA_Double)3.14;
	ti -> attrAny(any);
	ret = ti -> attrAny();
	CORBA_Double d;
	TEST(ret >>= d);
	TEST(d == 3.14);

	TestInterface::VariableStruct vStruct;
	vStruct.s = CORBA_string_dup("xyz");
	any <<= vStruct;
	CORBA_Any inOut;
	CORBA_Any_var out;
	ret = ti -> opAny(any, inOut, out);
	TestInterface::VariableStruct* vStructRet;
	TestInterface::VariableStruct* vStructInOut;
	TestInterface::VariableStruct* vStructOut;
	TEST(ret >>= vStructRet);
	TEST(inOut >>= vStructInOut);
	TEST(out >>= vStructOut);
	TEST(strcmp(vStructRet -> s, "xyz") == 0);
	TEST(strcmp(vStructInOut -> s, "xyz") == 0);
	TEST(strcmp(vStructOut -> s, "xyz") == 0);

	TestStruct1 v;
	v.s = -32768;
	v.l = -2147483647 - 1;
	v.d = 1E200;
	v.b = true;
	v.c = 'x';
	v.o = 0xff;
	v.str = (const char*)"abc";
	TestStruct1 vSave = v;

	any <<= v;

	ti -> attrAny(any);
	CORBA_Any_var any2 = ti -> attrAny();

	TestStruct1* vp;

	TEST(any2 >>= vp);
	TEST(vp -> s == vSave.s);
	TEST(vp -> l == vSave.l);
	TEST(vp -> d == vSave.d);
	TEST(vp -> c == vSave.c);
	TEST(vp -> b == vSave.b);
	TEST(vp -> o == vSave.o);
	TEST(strcmp(vp -> str, v.str) == 0);

	any <<= ti;
	ti -> attrAny(any);
	CORBA_Any_var any3 = ti -> attrAny();
	CORBA_Object_ptr obj;
	TEST(!(any3 >>= obj));
	TEST(any3 >>= CORBA_Any::to_object(obj));
	TestInterface_ptr ti2;
	TEST(any3 >>= ti2);
	TEST(obj -> _hash(1000) == ti2 -> _hash(1000));
	TEST(obj -> _is_equivalent(ti2));

	TestUnion1 u;
	TestUnion1* up;
	CORBA_TypeCode_var ut;
	u.l(123);
	any <<= u;
	ti -> attrAny(any);
	any3 = ti -> attrAny();
	TEST(any3 >>= up);
	ut = any3 -> type();
	TEST(up -> l() == 123);
	TEST(up -> _d() == -1);
	TEST(ut -> exactly_equal(_tc_TestUnion1));
	u.tc(_tc_TestUnion1);
	u._d(-6);
	TEST(u._d() == -6);
	any <<= u;
	ti -> attrAny(any);
	any3 = ti -> attrAny();
	TEST(any3 >>= up);
	ut = any3 -> type();
	TEST(up -> _d() == -6);
	TEST(up -> tc() -> exactly_equal(_tc_TestUnion1));
	TEST(ut -> exactly_equal(_tc_TestUnion1));

	TestStruct3 rs;
	rs.l = 287;
	rs.seq.length(3);
	rs.seq[0].l = 888;
	rs.seq[1].l = 999;
	rs.seq[2].l = 111;
	rs.seq[2].seq.length(1);
	rs.seq[2].seq[0].l = 222;
	any <<= rs;
	ti -> attrAny(any);
	ret = ti -> attrAny();
	TestStruct3* rsp;
	TEST(any >>= rsp);
	TEST(rsp -> l == 287);
	TEST(rsp -> seq.length() == 3);
	TEST(rsp -> seq[0].l == 888);
	TEST(rsp -> seq[1].l == 999);
	TEST(rsp -> seq[2].l == 111);
	TEST(rsp -> seq[2].seq.length() == 1);
	TEST(rsp -> seq[2].seq[0].l == 222);
    }

    {
	TestInterface::TestEnum ret;
	ti -> attrTestEnum(TestInterface::TestEnum2);
	ret = ti -> attrTestEnum();
	TEST(ret == TestInterface::TestEnum2);

	ti -> attrTestEnum(TestInterface::TestEnum3);
	ret = ti -> attrTestEnum();
	TEST(ret == TestInterface::TestEnum3);

	TestInterface::TestEnum inOut, out;
	inOut = TestInterface::TestEnum2;
	ret = ti -> opTestEnum(TestInterface::TestEnum3, inOut, out);
	TEST(ret == TestInterface::TestEnum3);
	TEST(inOut == TestInterface::TestEnum3);
	TEST(out == TestInterface::TestEnum3);
    }

    {
	TestInterface_var ret;
	ti -> attrTestInterface(ti);
	ret = ti -> attrTestInterface();
	TEST(ret -> _hash(1000) == ti -> _hash(1000));
	TEST(ret -> _is_equivalent(ti));

	TestInterface_var inOut, out;
	inOut = TestInterface::_duplicate(ti);
	ret = ti -> opTestInterface(ti, inOut.inout(), out.out());
	TEST(ret -> _hash(1000) == ti -> _hash(1000));
	TEST(ret -> _is_equivalent(ti));
	TEST(inOut -> _hash(5000) == ti -> _hash(5000));
	TEST(inOut -> _is_equivalent(ti));
	TEST(out -> _hash(2000) == ti -> _hash(2000));
	TEST(out -> _is_equivalent(ti));
    }

    {
	TestInterface::FixedStruct st;
	st.s = 100;
	st.l = -100;

	TestInterface::FixedStruct ret;
	ti -> attrFixedStruct(st);
	ret = ti -> attrFixedStruct();
	TEST(ret.s == st.s);
	TEST(ret.l == st.l);

	TestInterface::FixedStruct inOut, out;
	inOut.s = 1000;
	inOut.l = 10000;
	ret = ti -> opFixedStruct(st, inOut, out);
	TEST(ret.s == st.s);
	TEST(ret.l == st.l);
	TEST(inOut.s == st.s);
	TEST(inOut.l == st.l);
	TEST(out.s == st.s);
	TEST(out.l == st.l);
    }

    {
	TestInterface::VariableStruct st;
	st.s = CORBA_string_dup("$$$");

	TestInterface::VariableStruct_var ret;
	ti -> attrVariableStruct(st);
	ret = ti -> attrVariableStruct();
	TEST(strcmp(ret -> s, st.s) == 0);

	TestInterface::VariableStruct inOut;
	TestInterface::VariableStruct_var out;
	inOut.s = CORBA_string_dup("bla");
	ret = ti -> opVariableStruct(st, inOut, out);
	TEST(strcmp(ret -> s, st.s) == 0);
	TEST(strcmp(inOut.s, st.s) == 0);
	TEST(strcmp(out -> s, st.s) == 0);
    }

    {
	TestInterface::FixedUnion un;
	un.d(1.23);

	TestInterface::FixedUnion ret;
	ti -> attrFixedUnion(un);
	ret = ti -> attrFixedUnion();
	TEST(ret._d() == 2);
	TEST(ret.d() == 1.23);

	un.b(true);
	un._d(999);
	TestInterface::FixedUnion inOut, out;
	inOut.l(100);
	ret = ti -> opFixedUnion(un, inOut, out);
	TEST(ret._d() == 999);
	TEST(ret.b() == CORBA_TRUE);
	TEST(out._d() == 999);
	TEST(out.b() == CORBA_TRUE);
	TEST(inOut._d() == 999);
	TEST(inOut.b() == CORBA_TRUE);

	TestInterface::FixedStruct st;
	st.s = 10101;
	st.l = -10101;
	un.st(st);
	inOut.l(100);
	ret = ti -> opFixedUnion(un, inOut, out);
	TEST(ret._d() == 3);
	TEST(ret.st().s == 10101);
	TEST(ret.st().l == -10101);
	TEST(out._d() == 3);
	TEST(out.st().s == 10101);
	TEST(out.st().l == -10101);
	TEST(inOut._d() == 3);
	TEST(inOut.st().s == 10101);
	TEST(inOut.st().l == -10101);
    }

    {
	TestInterface::VariableUnion un;
	TestInterface::VariableStruct st;
	st.s = CORBA_string_dup("$$$");
	un.st(st);

	TestInterface::VariableUnion_var ret;
	ti -> attrVariableUnion(un);
	ret = ti -> attrVariableUnion();
	TEST(strcmp(ret -> st().s, "$$$") == 0);

	un.ti(ti);
	TestInterface::VariableUnion inOut;
	TestInterface::VariableUnion_var out;
	inOut.st(st);
	ret = ti -> opVariableUnion(un, inOut, out);
	TEST(ret -> ti() -> _hash(1000) == ti -> _hash(1000));
	TEST(ret -> ti() -> _is_equivalent(ti));
	TEST(inOut.ti() -> _hash(5000) == ti -> _hash(5000));
	TEST(inOut.ti() -> _is_equivalent(ti));
	TEST(out -> ti() -> _hash(2000) == ti -> _hash(2000));
	TEST(out -> ti() -> _is_equivalent(ti));
    }

    {
	TestInterface::StringSequence seq;
	seq.length(3);
	seq[0] = CORBA_string_dup("!!!");
	seq[1] = CORBA_string_dup("@@@");
	seq[2] = CORBA_string_dup("###");

	TestInterface::StringSequence_var ret;
	ti -> attrStringSequence(seq);
	ret = ti -> attrStringSequence();
	TEST(ret -> length() == 3);
	TEST(strcmp(ret[0], "!!!") == 0);
	TEST(strcmp(ret[1], "@@@") == 0);
	TEST(strcmp(ret[2], "###") == 0);

	TestInterface::StringSequence inOut;
	TestInterface::StringSequence_var out;
	inOut.length(2);
	inOut[0] = CORBA_string_dup("%");
	inOut[1] = CORBA_string_dup("^^");
	ret = ti -> opStringSequence(seq, inOut, out);
	TEST(ret -> length() == 5);
	TEST(strcmp(ret[0], "!!!") == 0);
	TEST(strcmp(ret[1], "@@@") == 0);
	TEST(strcmp(ret[2], "###") == 0);
	TEST(strcmp(ret[3], "%") == 0);
	TEST(strcmp(ret[4], "^^") == 0);
	TEST(inOut.length() == 5);
	TEST(strcmp(inOut[0], "!!!") == 0);
	TEST(strcmp(inOut[1], "@@@") == 0);
	TEST(strcmp(inOut[2], "###") == 0);
	TEST(strcmp(inOut[3], "%") == 0);
	TEST(strcmp(inOut[4], "^^") == 0);
	TEST(out -> length() == 5);
	TEST(strcmp(out[0], "!!!") == 0);
	TEST(strcmp(out[1], "@@@") == 0);
	TEST(strcmp(out[2], "###") == 0);
	TEST(strcmp(out[3], "%") == 0);
	TEST(strcmp(out[4], "^^") == 0);
    }

    {
	TestInterface::FixedArray ar =
	{
	    {
		{ 1, 2, 3, 4 },
		{ 10, -10, 11, -11 },
		{ -999, 0, 888, 123 }
	    },
	    {
		{ 17, 27, 37, 47 },
		{ 710, -710, 711, -711 },
		{ -99, 0, 88, 13 }
	    }
	};
	
	TestInterface::FixedArray_var ret;
#ifdef HAVE_VCPLUSPLUS_BUGS
	ti -> attrFixedArray((const TestInterface::FixedArray_slice*)ar);
#else
	ti -> attrFixedArray(ar);
#endif
	ret = ti -> attrFixedArray();
	for(i = 0 ; i < 2 ; i++)
	    for(j = 0 ; j < 3 ; j++)
		for(k = 0 ; k < 4 ; k++)
		{
		    TEST(ar[i][j][k] == ret[i][j][k]);
		}

	TestInterface::FixedArray inOut, out;
	for(i = 0 ; i < 2 ; i++)
	    for(j = 0 ; j < 3 ; j++)
		for(k = 0 ; k < 4 ; k++)
		    inOut[i][j][k] = (short)(i + j + k);
#ifdef HAVE_VCPLUSPLUS_BUGS
	ret = ti -> opFixedArray((const TestInterface::FixedArray_slice*)ar,
				 inOut, out);
#else
	ret = ti -> opFixedArray(ar, inOut, out);
#endif
	for(i = 0 ; i < 2 ; i++)
	    for(j = 0 ; j < 3 ; j++)
		for(k = 0 ; k < 4 ; k++)
		{
		    TEST(ar[i][j][k] == ret[i][j][k]);
		    TEST(ar[i][j][k] == inOut[i][j][k]);
		    TEST(ar[i][j][k] == out[i][j][k]);
		}
    }

    {
	TestInterface::VariableArray ar =
	{ 
	    {
		CORBA_string_dup("aa"),
		CORBA_string_dup("bb"),
		CORBA_string_dup("cc")
	    },
	    {
		CORBA_string_dup("AA"),
		CORBA_string_dup("BB"),
		CORBA_string_dup("CC")
	    }
	};
	
	TestInterface::VariableArray_var ret;
#ifdef HAVE_VCPLUSPLUS_BUGS
	ti -> attrVariableArray((const TestInterface::VariableArray_slice*)ar);
#else
	ti -> attrVariableArray(ar);
#endif
	ret = ti -> attrVariableArray();
	for(i = 0 ; i < 2 ; i++)
	    for(j = 0 ; j < 3 ; j++)
	    {
		TEST(strcmp(ar[i][j], ret[i][j]) == 0);
	    }

	TestInterface::VariableArray inOut;
	for(i = 0 ; i < 2 ; i++)
	    for(j = 0 ; j < 3 ; j++)
		inOut[i][j] = CORBA_string_dup("abc");
	TestInterface::VariableArray_var out;
#ifdef HAVE_VCPLUSPLUS_BUGS
	ret = ti -> opVariableArray((const TestInterface::VariableArray_slice*)
				    ar, inOut, out.out());
#else
	ret = ti -> opVariableArray(ar, inOut, out.out());
#endif
	for(i = 0 ; i < 2 ; i++)
	    for(j = 0 ; j < 3 ; j++)
	    {
		TEST(strcmp(ar[i][j], ret[i][j]) == 0);
		TEST(strcmp(ar[i][j], inOut[i][j]) == 0);
		TEST(strcmp(ar[i][j], out[i][j]) == 0);
	    }
    }

    {
	TestInterface::FixedArray ar0 =
	{
	    {
		{ 1, 2, 3, 4 },
		{ 10, -10, 11, -11 },
		{ -999, 0, 888, 123 }
	    },
	    {
		{ 17, 27, 37, 47 },
		{ 710, -710, 711, -711 },
		{ -99, 0, 88, 13 }
	    }
	};
	
	TestInterface::FixedArray ar1 =
	{
	    {
		{ 2, 3, 4, 1 },
		{ 10, 11, 11, -10 },
		{ -0, 939, 123, 888 }
	    },
	    {
		{ 17, 37, 47, 27 },
		{ 710, -710, 711, -711 },
		{ -0, -99, 13, 8338 }
	    }
	};
	
	TestInterface::FixedArray ar2 =
	{
	    {
		{ 1, 2, -3, -234 },
		{ 10, -11, 11, -10 },
		{ -999, 30, 1888, 123 }
	    },
	    {
		{ 27, 37, 117, 47 },
		{ 710, -7150, 711, -711 },
		{ -0, 13, 929, 88 }
	    }
	};
	
	TestInterface::FixedArraySequence seq;
	seq.length(3);
	TestInterface::FixedArray_copy(ar0, seq[0]);
	TestInterface::FixedArray_copy(ar1, seq[1]);
	TestInterface::FixedArray_copy(ar2, seq[2]);

	TestInterface::FixedArraySequence_var ret;

	ti -> attrFixedArraySequence(seq);
	ret = ti -> attrFixedArraySequence();

	for(l = 0 ; l < 3 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
		    {
			TEST(seq[l][i][j][k] == ret[l][i][j][k]);
		    }

	TestInterface::FixedArraySequence inOut;
	inOut.length(4);
	for(l = 0 ; l < 4 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
			inOut[l][i][j][k] = (short)(i + j + k + l);

	TestInterface::FixedArraySequence_var out;

	ret = ti -> opFixedArraySequence(seq, inOut, out);

	TEST(ret -> length() == 7);
	TEST(out -> length() == 7);
	TEST(inOut.length() == 7);

	for(l = 0 ; l < 3 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
		    {
			TEST(seq[l][i][j][k] == ret[l][i][j][k]);
			TEST(seq[l][i][j][k] == inOut[l][i][j][k]);
			TEST(seq[l][i][j][k] == out[l][i][j][k]);
		    }

	for(l = 0 ; l < 4 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
		    {
			TEST(ret[3 + l][i][j][k] ==
			     (CORBA_Long)(i + j + k + l));
			TEST(inOut[3 + l][i][j][k] ==
			     (CORBA_Long)(i + j + k + l));
			TEST(out[3 + l][i][j][k] ==
			     (CORBA_Long)(i + j + k + l));
		    }
    }

    {
	TestInterface::VariableArray ar0 =
	{ 
	    {
		CORBA_string_dup("aa"),
		CORBA_string_dup("bb"),
		CORBA_string_dup("cc")
	    },
	    {
		CORBA_string_dup("AA"),
		CORBA_string_dup("BB"),
		CORBA_string_dup("CC")
	    }
	};

	TestInterface::VariableArray ar1 =
	{ 
	    {
		CORBA_string_dup("a~a"),
		CORBA_string_dup("b~b"),
		CORBA_string_dup("c~c")
	    },
	    {
		CORBA_string_dup("A~A"),
		CORBA_string_dup("B~B"),
		CORBA_string_dup("C~C")
	    }
	};

	TestInterface::VariableArraySequence seq;
	seq.length(2);
	TestInterface::VariableArray_copy(ar0, seq[0]);
	TestInterface::VariableArray_copy(ar1, seq[1]);

	TestInterface::VariableArraySequence_var ret;

	ti -> attrVariableArraySequence(seq);
	ret = ti -> attrVariableArraySequence();

	for(l = 0 ; l < 2 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		{
		    TEST(strcmp(seq[l][i][j], ret[l][i][j]) == 0);
		}

	TestInterface::VariableArraySequence inOut;
	inOut.length(4);
	for(l = 0 ; l < 4 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    inOut[l][i][j] = CORBA_string_dup("***");

	TestInterface::VariableArraySequence_var out;
	
	ret = ti -> opVariableArraySequence(seq, inOut, out);

	TEST(ret -> length() == 6);
	TEST(out -> length() == 6);
	TEST(inOut.length() == 6);

	for(l = 0 ; l < 2 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		{
		    TEST(strcmp(seq[l][i][j], ret[l][i][j]) == 0);
		    TEST(strcmp(seq[l][i][j], inOut[l][i][j]) == 0);
		    TEST(strcmp(seq[l][i][j], out[l][i][j]) == 0);
		}

	for(l = 0 ; l < 4 ; l++)
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		{
		    TEST(strcmp(ret[2 + l][i][j], "***") == 0);
		    TEST(strcmp(inOut[2 + l][i][j], "***") == 0);
		    TEST(strcmp(out[2 + l][i][j], "***") == 0);
		}
    }
}

