// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

void
TestStubContext(TestInterface_ptr ti, CORBA_ORB_ptr orb)
{
    CORBA_Context_var ctx;
    CORBA_Context_var ctx2;

    {
	orb -> get_default_context(ctx.out());
	
	TestInterface::StringSequence_var seq;
	
	try
	{
	    seq = ti -> opContext("*", ctx);
	    TEST(false);
	}
	catch(const CORBA_BAD_CONTEXT&)
	{
	    // Expected
	}
    }

    {
	CORBA_Any any;
	CORBA_ULong i;
	TestInterface::StringSequence_var seq;

	orb -> get_default_context(ctx.out());

	any <<= (const char*)"A1";
	ctx -> set_one_value("A", any);

	any <<= (const char*)"A2";
	ctx -> set_one_value("AAA", any);

	any <<= (const char*)"B1";
	ctx -> set_one_value("B", any);

	any <<= (const char*)"B2";
	ctx -> set_one_value("BBB", any);

	any <<= (const char*)"X1";
	ctx -> set_one_value("X", any);

	any <<= (const char*)"X2";
	ctx -> set_one_value("XXX", any);

	any <<= (const char*)"Y1";
	ctx -> set_one_value("Y", any);

	any <<= (const char*)"Y2";
	ctx -> set_one_value("YYY", any);

	seq = ti -> opContext("*", ctx);
	TEST(seq -> length() == 3 * 2);
	i = 0;
	TEST(strcmp(seq[i++], "A") == 0 &&
	     strcmp(seq[i++], "A1") == 0);
	TEST(strcmp(seq[i++], "AAA") == 0 &&
	     strcmp(seq[i++], "A2") == 0);
	TEST(strcmp(seq[i++], "X") == 0 &&
	     strcmp(seq[i++], "X1") == 0);

	seq = ti -> opContext("A*", ctx);
	TEST(seq -> length() == 2 * 2);
	i = 0;
	TEST(strcmp(seq[i++], "A") == 0 &&
	     strcmp(seq[i++], "A1") == 0);
	TEST(strcmp(seq[i++], "AAA") == 0 &&
	     strcmp(seq[i++], "A2") == 0);

	seq = ti -> opContext("AA*", ctx);
	TEST(seq -> length() == 1 * 2);
	i = 0;
	TEST(strcmp(seq[i++], "AAA") == 0 &&
	     strcmp(seq[i++], "A2") == 0);

	seq = ti -> opContext("A", ctx);
	TEST(seq -> length() == 1 * 2);
	i = 0;
	TEST(strcmp(seq[i++], "A") == 0 &&
	     strcmp(seq[i++], "A1") == 0);

	ctx -> create_child("child", ctx2.out());

	any <<= (const char*)"C1";
	ctx2 -> set_one_value("C", any);

	any <<= (const char*)"C2";
	ctx2 -> set_one_value("CCC", any);

	any <<= (const char*)"X1-1";
	ctx2 -> set_one_value("X", any);

	seq = ti -> opContext("*", ctx2);
	TEST(seq -> length() == 5 * 2);
	i = 0;
	TEST(strcmp(seq[i++], "A") == 0 &&
	     strcmp(seq[i++], "A1") == 0);
	TEST(strcmp(seq[i++], "AAA") == 0 &&
	     strcmp(seq[i++], "A2") == 0);
	TEST(strcmp(seq[i++], "C") == 0 &&
	     strcmp(seq[i++], "C1") == 0);
	TEST(strcmp(seq[i++], "CCC") == 0 &&
	     strcmp(seq[i++], "C2") == 0);
	TEST(strcmp(seq[i++], "X") == 0 &&
	     strcmp(seq[i++], "X1-1") == 0);
    }
}
