// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/OBPolicies.h>
#include <OB/Util.h>

#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

#ifdef HAVE_UNISTD_H
#   include <unistd.h>
#endif

void
TestStubTimeout(CORBA_ORB_ptr orb, TestInterfaceTimeout_ptr tiOriginal)
{
    //
    // Create policy list containing new timeout policy
    //
    CORBA_PolicyList pl(1);
    pl.length(1);
    CORBA_Any any;
    any <<= (CORBA_ULong)2000;
    pl[0] = orb -> create_policy(OB_TIMEOUT_POLICY, any);
    
    //
    // _set_policy_overrides returns new proxy, which this policy
    // applied.
    //
    CORBA_Object_var obj = tiOriginal ->
                               _set_policy_overrides(pl, CORBA_ADD_OVERRIDE);
    //
    // _narrow to correct type
    //
    TestInterfaceTimeout_var ti = TestInterfaceTimeout::_narrow(obj);
    assert(!CORBA_is_nil(ti));
    
    ti -> sleepOneway(3);

    try
    {
	ti -> sleepTwoway(0);
	TEST(false);
    }
    catch(const CORBA_NO_RESPONSE&)
    {
    }

#ifdef WIN32
    Sleep(2000);
#else
    sleep(2);
#endif

    try
    {
	ti -> sleepTwoway(0);
    }
    catch(const CORBA_NO_RESPONSE&)
    {
	TEST(false);
    }
}
