// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Test1.h>
#include <Test2.h>
#include <TestMacro.h>

void
TestTypeCode()
{
    {
	CORBA_TCKind kind = _tc_TestStruct1 -> kind();
	TEST(kind == CORBA_tk_struct);

	CORBA_String_var name = _tc_TestStruct1 -> name();
	TEST(strcmp(name, "TestStruct1") == 0);

	CORBA_ULong count = _tc_TestStruct1 -> member_count();
	TEST(count == 7);

	CORBA_String_var name0 = _tc_TestStruct1 -> member_name(0);
	TEST(strcmp(name0, "s") == 0);

	CORBA_String_var name1 = _tc_TestStruct1 -> member_name(1);
	TEST(strcmp(name1, "l") == 0);

	CORBA_String_var name2 = _tc_TestStruct1 -> member_name(2);
	TEST(strcmp(name2, "d") == 0);

	CORBA_String_var name3 = _tc_TestStruct1 -> member_name(3);
	TEST(strcmp(name3, "b") == 0);

	CORBA_String_var name4 = _tc_TestStruct1 -> member_name(4);
	TEST(strcmp(name4, "c") == 0);

	CORBA_String_var name5 = _tc_TestStruct1 -> member_name(5);
	TEST(strcmp(name5, "o") == 0);

	CORBA_String_var name6 = _tc_TestStruct1 -> member_name(6);
	TEST(strcmp(name6, "str") == 0);

	CORBA_TypeCode_var type0 = _tc_TestStruct1 -> member_type(0);
	TEST(type0-> exactly_equal(CORBA__tc_short));

	CORBA_TypeCode_var type1 = _tc_TestStruct1 -> member_type(1);
	TEST(type1-> exactly_equal(CORBA__tc_long));

	CORBA_TypeCode_var type2 = _tc_TestStruct1 -> member_type(2);
	TEST(type2-> exactly_equal(CORBA__tc_double));

	CORBA_TypeCode_var type3 = _tc_TestStruct1 -> member_type(3);
	TEST(type3-> exactly_equal(CORBA__tc_boolean));

	CORBA_TypeCode_var type4 = _tc_TestStruct1 -> member_type(4);
	TEST(type4-> exactly_equal(CORBA__tc_char));

	CORBA_TypeCode_var type5 = _tc_TestStruct1 -> member_type(5);
	TEST(type5-> exactly_equal(CORBA__tc_octet));

	CORBA_TypeCode_var type6 = _tc_TestStruct1 -> member_type(6);
	TEST(type6-> exactly_equal(CORBA__tc_string));
    }

    {
	CORBA_TCKind kind = _tc_TestStruct2 -> kind();
	TEST(kind == CORBA_tk_struct);

	CORBA_String_var name = _tc_TestStruct2 -> name();
	TEST(strcmp(name, "TestStruct2") == 0);

	CORBA_ULong count = _tc_TestStruct2 -> member_count();
	TEST(count == 4);

	CORBA_String_var name0 = _tc_TestStruct2 -> member_name(0);
	TEST(strcmp(name0, "s") == 0);

	CORBA_TypeCode_var type0 = _tc_TestStruct2 -> member_type(0);
	TEST(type0-> exactly_equal(_tc_TestStruct1));

	CORBA_String_var name1 = _tc_TestStruct2 -> member_name(1);
	TEST(strcmp(name1, "a") == 0);

	CORBA_TypeCode_var type1 = _tc_TestStruct2 -> member_type(1);
	TEST(type1-> exactly_equal(CORBA__tc_any));

	CORBA_String_var name2 = _tc_TestStruct2 -> member_name(2);
	TEST(strcmp(name2, "da") == 0);

	CORBA_TypeCode_var type2 = _tc_TestStruct2 -> member_type(2);
	TEST(type2-> exactly_equal(_tc_DoubleArray));

	CORBA_String_var name3 = _tc_TestStruct2 -> member_name(3);
	TEST(strcmp(name3, "sa") == 0);

	CORBA_TypeCode_var type3 = _tc_TestStruct2 -> member_type(3);
	//TEST(type3 -> exactly_equal(_tc_...));
    }

    {
	CORBA_TCKind kind = _tc_TestStruct3 -> kind();
	TEST(kind == CORBA_tk_struct);

	CORBA_String_var name = _tc_TestStruct3 -> name();
	TEST(strcmp(name, "TestStruct3") == 0);

	CORBA_ULong count = _tc_TestStruct3 -> member_count();
	TEST(count == 2);

	CORBA_String_var name0 = _tc_TestStruct3 -> member_name(0);
	TEST(strcmp(name0, "l") == 0);

	CORBA_TypeCode_var type0 = _tc_TestStruct3 -> member_type(0);
	TEST(type0 -> exactly_equal(CORBA__tc_long));

	CORBA_String_var name1 = _tc_TestStruct3 -> member_name(1);
	TEST(strcmp(name1, "seq") == 0);

	CORBA_TypeCode_var type1 = _tc_TestStruct3 -> member_type(1);
	CORBA_TypeCode_var contentType = type1 -> content_type();
	TEST(contentType -> exactly_equal(_tc_TestStruct3));
    }

    {
	CORBA_TCKind kind = _tc_TestStruct4 -> kind();
	TEST(kind == CORBA_tk_struct);

	CORBA_String_var name = _tc_TestStruct4 -> name();
	TEST(strcmp(name, "TestStruct4") == 0);

	CORBA_ULong count = _tc_TestStruct4 -> member_count();
	TEST(count == 2);

	CORBA_String_var name0 = _tc_TestStruct4 -> member_name(0);
	TEST(strcmp(name0, "a") == 0);

	CORBA_TypeCode_var type0 = _tc_TestStruct4 -> member_type(0);
	TEST(type0 -> exactly_equal(_tc_TestStruct3));

	CORBA_String_var name1 = _tc_TestStruct4 -> member_name(1);
	TEST(strcmp(name1, "b") == 0);

	CORBA_TypeCode_var type1 = _tc_TestStruct4 -> member_type(1);
	CORBA_TypeCode_var contentType = type1 -> content_type();
	TEST(contentType -> exactly_equal(_tc_TestStruct3));
    }

    {
	CORBA_TCKind kind = _tc_TestUnion4 -> kind();
	TEST(kind == CORBA_tk_union);

	CORBA_String_var name = _tc_TestUnion4 -> name();
	TEST(strcmp(name, "TestUnion4") == 0);

	CORBA_ULong count = _tc_TestUnion4 -> member_count();
	TEST(count == 2);

	CORBA_String_var name0 = _tc_TestUnion4 -> member_name(0);
	TEST(strcmp(name0, "seq") == 0);

	CORBA_TypeCode_var type0 = _tc_TestUnion4 -> member_type(0);
	CORBA_TypeCode_var contentType = type0 -> content_type();
	TEST(contentType -> exactly_equal(_tc_TestUnion4));

	CORBA_String_var name1 = _tc_TestUnion4 -> member_name(1);
	TEST(strcmp(name1, "c") == 0);

	CORBA_TypeCode_var type1 = _tc_TestUnion4 -> member_type(1);
	TEST(type1 -> exactly_equal(CORBA__tc_char));
    }

    {
	CORBA_TypeCode_ptr p;

	p = CORBA__tc_RepositoryId;
	TEST(strcmp(p -> name(), "RepositoryId") == 0);

	p = CORBA__tc_ScopedName;
	TEST(strcmp(p -> name(), "ScopedName") == 0);

	p = CORBA__tc_Identifier;
	TEST(strcmp(p -> name(), "Identifier") == 0);

	p = CORBA__tc_DefinitionKind;
	TEST(strcmp(p -> name(), "DefinitionKind") == 0);

	p = CORBA__tc_IRObject;
	TEST(strcmp(p -> name(), "IRObject") == 0);

	p = CORBA__tc_VersionSpec;
	TEST(strcmp(p -> name(), "VersionSpec") == 0);

	p = CORBA__tc_Contained;
	TEST(strcmp(p -> name(), "Contained") == 0);

	p = CORBA_Contained::_tc_Description;
	TEST(strcmp(p -> name(), "Description") == 0);

	p = CORBA__tc_InterfaceDefSeq;
	TEST(strcmp(p -> name(), "InterfaceDefSeq") == 0);

	p = CORBA__tc_ContainedSeq;
	TEST(strcmp(p -> name(), "ContainedSeq") == 0);

	p = CORBA__tc_StructMember;
	TEST(strcmp(p -> name(), "StructMember") == 0);

	p = CORBA__tc_StructMemberSeq;
	TEST(strcmp(p -> name(), "StructMemberSeq") == 0);

	p = CORBA__tc_UnionMember;
	TEST(strcmp(p -> name(), "UnionMember") == 0);

	p = CORBA__tc_UnionMemberSeq;
	TEST(strcmp(p -> name(), "UnionMemberSeq") == 0);

	p = CORBA__tc_EnumMemberSeq;
	TEST(strcmp(p -> name(), "EnumMemberSeq") == 0);

	p = CORBA__tc_Container;
	TEST(strcmp(p -> name(), "Container") == 0);

	p = CORBA_Container::_tc_Description;
	TEST(strcmp(p -> name(), "Description") == 0);

	p = CORBA_Container::_tc_DescriptionSeq;
	TEST(strcmp(p -> name(), "DescriptionSeq") == 0);

	p = CORBA__tc_IDLType;
	TEST(strcmp(p -> name(), "IDLType") == 0);

	p = CORBA__tc_PrimitiveKind;
	TEST(strcmp(p -> name(), "PrimitiveKind") == 0);

	p = CORBA__tc_Repository;
	TEST(strcmp(p -> name(), "Repository") == 0);

	p = CORBA__tc_ModuleDef;
	TEST(strcmp(p -> name(), "ModuleDef") == 0);

	p = CORBA__tc_ModuleDescription;
	TEST(strcmp(p -> name(), "ModuleDescription") == 0);

	p = CORBA__tc_ConstantDef;
	TEST(strcmp(p -> name(), "ConstantDef") == 0);

	p = CORBA__tc_ConstantDescription;
	TEST(strcmp(p -> name(), "ConstantDescription") == 0);

	p = CORBA__tc_TypedefDef;
	TEST(strcmp(p -> name(), "TypedefDef") == 0);

	p = CORBA__tc_TypeDescription;
	TEST(strcmp(p -> name(), "TypeDescription") == 0);

	p = CORBA__tc_StructDef;
	TEST(strcmp(p -> name(), "StructDef") == 0);

	p = CORBA__tc_UnionDef;
	TEST(strcmp(p -> name(), "UnionDef") == 0);

	p = CORBA__tc_EnumDef;
	TEST(strcmp(p -> name(), "EnumDef") == 0);

	p = CORBA__tc_AliasDef;
	TEST(strcmp(p -> name(), "AliasDef") == 0);

	p = CORBA__tc_PrimitiveDef;
	TEST(strcmp(p -> name(), "PrimitiveDef") == 0);

	p = CORBA__tc_StringDef;
	TEST(strcmp(p -> name(), "StringDef") == 0);

	p = CORBA__tc_SequenceDef;
	TEST(strcmp(p -> name(), "SequenceDef") == 0);

	p = CORBA__tc_ArrayDef;
	TEST(strcmp(p -> name(), "ArrayDef") == 0);

	p = CORBA__tc_ExceptionDef;
	TEST(strcmp(p -> name(), "ExceptionDef") == 0);

	p = CORBA__tc_ExceptionDescription;
	TEST(strcmp(p -> name(), "ExceptionDescription") == 0);

	p = CORBA__tc_AttributeMode;
	TEST(strcmp(p -> name(), "AttributeMode") == 0);

	p = CORBA__tc_AttributeDef;
	TEST(strcmp(p -> name(), "AttributeDef") == 0);

	p = CORBA__tc_AttributeDescription;
	TEST(strcmp(p -> name(), "AttributeDescription") == 0);

	p = CORBA__tc_OperationMode;
	TEST(strcmp(p -> name(), "OperationMode") == 0);

	p = CORBA__tc_ParameterMode;
	TEST(strcmp(p -> name(), "ParameterMode") == 0);

	p = CORBA__tc_ParameterDescription;
	TEST(strcmp(p -> name(), "ParameterDescription") == 0);

	p = CORBA__tc_ParDescriptionSeq;
	TEST(strcmp(p -> name(), "ParDescriptionSeq") == 0);

	p = CORBA__tc_ContextIdentifier;
	TEST(strcmp(p -> name(), "ContextIdentifier") == 0);

	p = CORBA__tc_ContextIdSeq;
	TEST(strcmp(p -> name(), "ContextIdSeq") == 0);

	p = CORBA__tc_ExceptionDefSeq;
	TEST(strcmp(p -> name(), "ExceptionDefSeq") == 0);

	p = CORBA__tc_ExcDescriptionSeq;
	TEST(strcmp(p -> name(), "ExcDescriptionSeq") == 0);

	p = CORBA__tc_OperationDef;
	TEST(strcmp(p -> name(), "OperationDef") == 0);

	p = CORBA__tc_OperationDescription;
	TEST(strcmp(p -> name(), "OperationDescription") == 0);

	p = CORBA__tc_RepositoryIdSeq;
	TEST(strcmp(p -> name(), "RepositoryIdSeq") == 0);

	p = CORBA__tc_OpDescriptionSeq;
	TEST(strcmp(p -> name(), "OpDescriptionSeq") == 0);

	p = CORBA__tc_AttrDescriptionSeq;
	TEST(strcmp(p -> name(), "AttrDescriptionSeq") == 0);

	p = CORBA__tc_InterfaceDef;
	TEST(strcmp(p -> name(), "InterfaceDef") == 0);

	p = CORBA_InterfaceDef::_tc_FullInterfaceDescription;
	TEST(strcmp(p -> name(), "FullInterfaceDescription") == 0);

	p = CORBA__tc_InterfaceDescription;
	TEST(strcmp(p -> name(), "InterfaceDescription") == 0);
    }
}
